from viavi.evm import *


@COMMAND("diags", {"list": {}, "all": {}})
def diags_command(cmd):
    options = list(diags_command.parameters.keys())
    params = cmd.split()[1:]
    name = cmd.split()[0]

    if len(params) == 0:
        print_help(name+" ("+"|".join(options)+")")
        return
    if len(params) == 1:
            if params[0] == "help":
                print_help(name+" ("+"|".join(options)+")")
                return
    if params[0] not in options:
        print_error("SyntaxError "+params[0])
        print_help(name+" ("+"|".join(options)+")"+")")
        return

    if params[0] == "list":
        for cmd in I().list_commands():
            if cmd != "Exit":
                fc = I().get_command(cmd)
                if 'diag' in dir(fc):
                    print_help(cmd)

    if params[0] == "all":
        for cmd in I().list_commands():
            if cmd != "Exit":
                fc = I().get_command(cmd)
                if 'diag' in dir(fc):
                    fc(cmd)


@COMMAND("resource", {"print": {}, "stop": {"all": {}}, "start": {"all": {}}})
def resources_command(cmd):
    options = list(resources_command.parameters.keys())
    params = cmd.split()[1:]
    name = cmd.split()[0]

    if len(params) == 0:
        print_help(name+" ("+"|".join(options)+")")
        return

    if params[0] == "print":
        if "resources" in __builtins__:
            for k in __builtins__["resources"].keys():
                s = "off"
                if __builtins__["resources"][k].enabled:
                    s = "on"
                print_help("%s: %s" % (k, s))

    if params[0] == "start":
        if params[1] == "all":
            for d in __builtins__["resources"].keys():
                __builtins__["resources"][d](True)
        else:
            if params[1] in __builtins__["resources"].keys():
                __builtins__["resources"][params[1]](True)

    if params[0] == "stop":
        if params[1] == "all":
            for d in __builtins__["resources"].keys():
                __builtins__["resources"][d](False)
        else:
            if params[1] in __builtins__["resources"].keys():
                __builtins__["resources"][params[1]](False)
