import QtQuick 2.1
import common 1.0
import graph_plugin 1.0

Item {
    id: curtain

    property ZoomRect zoomRect
    property real leftBound
    property real rightBound
    property string shadeColor: "#80000000"
    signal doubleTapped

    Rectangle {
        id: leftShade
        anchors {
            left: parent.left
            right: activeView.left
            top: parent.top
            bottom: parent.bottom
        }
        color: shadeColor
        border.color: shadeColor
        border.width: 1
    }

    Rectangle {
        id: rightShade
        anchors {
            left: activeView.right
            right: parent.right
            top: parent.top
            bottom: parent.bottom
        }
        color: shadeColor
        border.color: shadeColor
        border.width: 1
    }

    Rectangle {
        id: activeView
        anchors.top: parent.top
        anchors.bottom: parent.bottom
        width: curtain.width * curtain.zoomRect.width
        color: "#0047B2"
        opacity: dragPan.pressed ? 0.5 : 0.0

        Behavior on opacity { NumberAnimation { duration: 250 } }

        MouseArea {
            id: dragPan
            anchors.fill: parent
            drag.target: parent
            drag.axis: Drag.XAxis
            drag.minimumX: 0
            drag.maximumX: curtain.width - activeView.width
            onDoubleClicked: doubleTapped()
        }
        onXChanged: curtain.zoomRect.moveLeft(x / curtain.width);
    }

    onZoomRectChanged: {
        zoomRect.leftChanged.connect(updateLeft);
        zoomRect.rightChanged.connect(updateRight);
    }

    function updateLeft() {
        var left = width * zoomRect.left;
        activeView.x = left;
        leftBound = left;
    }

    function updateRight() {
        rightBound = width * zoomRect.right;
    }
}
