import QtQuick 2.5

//import 'ViaviVirtualKeyboard'

Row {
    property bool secondPageOn: false

    readonly property alias layoutSwitchButton: kbLayoutSwitcher

    anchors.left: parent.left
    anchors.bottom: parent.bottom

    width: parent.width - keyboardUtils.widthRightColumn
    height: keyboardUtils.heightBottomRow

    property bool hasSecondPage: false

    KeyboardButton {
        buttonLabel: secondPageOn ? "abc": InputContext.capsLock ? "[AUTO]": "[auto]"
        buttonEnabled: hasSecondPage
        buttonWidth: keyboardUtils.buttonWidthCustom
        buttonType: keyboardUtils.buttonTypeCustom
    }

    KeyboardCustomButton {
        id: kbLayoutSwitcher
        buttonLabel: 'ShowLayouts'
        buttonHasPicture: true
        buttonPicturePath: keyboardUtils.buttonIconPath + 'earth_lines.png'
    }


    KeyboardCustomButton {
        buttonLabel: "LeftArrow"
        buttonHasPicture: true
        buttonPicturePath: keyboardUtils.buttonIconPath + "Icon_LeftArrow.png"
    }

    KeyboardButton {
        buttonLabel: " "
        buttonWidth: keyboardUtils.buttonWidthAlphaKeyb * 4
    }

    KeyboardCustomButton {
        buttonLabel: "RightArrow"
        buttonHasPicture: true
        buttonPicturePath: keyboardUtils.buttonIconPath + "Icon_RightArrow.png"
    }

    /* Empty space */
    Item { width: keyboardUtils.buttonWidthAlphaKeyb * 2 ; height: parent.height }
}

