import QtQuick 2.8
import QtQuick.Layouts 1.8
import QtQuick.Controls 2.1

import com.viavi.style 1.0
import com.viavi.style.components 1.0
import com.viavi.style.components.menudata 1.0

ViaviMenuLineInputText {
    id: root

    property alias secondTextData: secondTextFieldProperties
    TextFieldData {
        id: secondTextFieldProperties
    }
    property int secondInputTextWidth: ViaviStyle.layout.menuTextFieldWidth

    signal secondTextClicked();

    tailContentItem: RowLayout {
        ViaviInputText {
            id: secondInputText
            text: secondTextFieldProperties.text
            enabled: secondTextFieldProperties.enabled
            visible: secondTextFieldProperties.visible
            implicitWidth: secondInputTextWidth
            onTextEdited: {
                if (secondTextFieldProperties.text !== text)
                    secondTextFieldProperties.text = text
            }  

            onClicked: {
                root.secondTextClicked()
            }
            implicitHeight: ViaviStyle.layout.setupMenuLineHeight
            Layout.fillWidth: tailContentFillWidth
        }

        Item{
            visible: tailContentFillWidth && !secondInputText.visible
            width: secondInputTextWidth
            implicitHeight: secondInputText.implicitHeight
            implicitWidth: secondInputText.implicitWidth
            Layout.fillWidth: tailContentFillWidth
        }
    }
}
