import QtQuick 2.8
import QtQuick.Layouts 1.8
import QtQuick.Controls 2.1

import com.viavi.style 1.0
import com.viavi.style.components 1.0
import com.viavi.style.components.menudata 1.0

ViaviMenuLineInputText {
    id: root

    property alias buttonData: buttonProperties
    ToolButtonData {
        id: buttonProperties
        enabled: true
    }

    signal buttonClicked();

    tailContentItem: ViaviOptionButton {
        id: button
        text: buttonProperties.text
        enabled: buttonProperties.enabled
        visible: buttonProperties.visible
        selected: true
        width: ViaviStyle.layout.menuTextFieldWidth
        onClicked: {
            root.buttonClicked()
        }
        implicitHeight: ViaviStyle.layout.setupMenuLineHeight
        implicitWidth: ViaviStyle.layout.menuTextFieldWidth
    }
}
