import QtQuick 2.8
import QtQuick.Layouts 1.8

import com.viavi.style 1.0
import com.viavi.style.components 1.0
import com.viavi.style.components.menudata 1.0

ViaviMenuLineComboBox {
    id: root
    property Component tailContentItem2: null

    property alias checkBoxData: checkBoxProperties
    CheckBoxData {
        id: checkBoxProperties
    }

    signal sgnToggled(value: bool)

    tailContentItem: RowLayout {
        ViaviCheckBox {
            id: checkBox
            checked: checkBoxProperties.checked
            text: checkBoxProperties.text
            enabled: checkBoxProperties.enabled
            visible: checkBoxProperties.visible

            MouseArea{
                anchors.fill: parent
                onClicked: root.sgnToggled(!checkBox.checked)
            }
        }

        Loader {
            id: tailContentItem2Loader
            sourceComponent: tailContentItem2
        }
    }
}
