import QtQuick 2.8
import QtQuick.Layouts 1.8

import com.viavi.style 1.0
import com.viavi.style.components 1.0
import com.viavi.style.components.menudata 1.0

ViaviMenuLineCheckBox {
    id: root
    property Component tailContentItem2: null

    property alias textData: textFieldProperties
    TextFieldData {
        id: textFieldProperties
    }

    signal textClicked()

    tailContentItem: RowLayout {
        ViaviInputText {
            id: inputText
            text: textFieldProperties.text
            enabled: textFieldProperties.enabled
            visible: textFieldProperties.visible
            width: ViaviStyle.layout.menuTextFieldWidth
            onTextEdited: {
                if (textFieldProperties.text !== text)
                    textFieldProperties.text = text
            }

            onClicked: {
                root.textClicked()
            }

            implicitHeight: ViaviStyle.layout.setupMenuLineHeight
            implicitWidth: ViaviStyle.layout.menuTextFieldWidth
            Layout.fillWidth: tailContentFillWidth
        }

        /**
         *Add an empty item to preserve size even if inputText is not visible.
         *Make's sure resizeing of elements works correctly no matter the state of the component.
         */
        Item{
            id: fillerItem
            visible: tailContentFillWidth && !inputText.visible
            width: ViaviStyle.layout.menuTextFieldWidth
            implicitHeight: inputText.implicitHeight
            implicitWidth: inputText.implicitWidth
            Layout.fillWidth: tailContentFillWidth
        }
        
        Loader {
            id: tailContentItem2Loader
            sourceComponent: tailContentItem2
        }
    }
}
