import QtQml 2.3
import QtQuick 2.9
import QtQuick.Controls 2.0

import com.viavi.style 1.0
import com.viavi.style.components 1.0
import com.viavi.style.components.menudata 1.0

ViaviMenuLineControl {
    id: root

    property alias checkBoxData: checkBoxProperties
    CheckBoxData {
        id: checkBoxProperties
    }

    signal sgnToggled(value: bool)

    mainContentItem: ViaviCheckBox {
        id: checkBox
        checked: checkBoxProperties.checked
        text: checkBoxProperties.text
        enabled: checkBoxProperties.enabled
        visible: checkBoxProperties.visible
        
        MouseArea{
            anchors.fill: parent
            onClicked: root.sgnToggled(!checkBox.checked)
        }
    }
}
