import QtQuick 2.7
import QtQuick.Controls 2.0
import QtGraphicalEffects 1.0

import com.viavi.style 1.0

//NOTE: same as CheckBoxItem, but with purple and a cross sign instead of tick sign
CheckBoxItem {
    id: root

    indicator: Rectangle {
        implicitWidth: implicitHeight
        implicitHeight: ViaviStyle.layout.defaultButtonHeight

        x: root.leftPadding
        y: parent.height / 2 - height / 2
        border.color: enabled ? ViaviStyle.colors.activeColor : ViaviStyle.colors.disabledItemColor
        border.width: ViaviStyle.layout.borderSize
        ColorImage {
            id: checkIndicator
            fillMode: Image.PreserveAspectFit
            width: parent.height
            height: width
            source: "/acterna/storage/look-and-feel/generic/Check_32.png" //Note: FOFTSA-1195
            visible: root.checked
            color: root.enabled ? ViaviStyle.colors.activeColor : ViaviStyle.colors.disabledItemColor
        }
    }
    
    contentItem: Text {
        text: root.text
        font: root.font
        color: enabled ? ViaviStyle.colors.mainInfoColor : ViaviStyle.colors.disabledItemColor
        verticalAlignment: Text.AlignVCenter
        leftPadding: root.indicator.width + root.spacing
        visible: text.length > 0
    }
}
