import QtQuick 2.3
import QtQuick.Controls 2.0
import QtQuick.Layouts 1.2


import com.viavi.style 1.0

//TODO: customise Button
AbstractButton {
    id: button

    property alias textHorizontalAlignment: text.horizontalAlignment
    property alias textAnchors: text.anchors
    property string iconPath: ''
    property alias radius: rectangle.radius

    readonly property real opacityEnabled: 1
    readonly property real opacityDisabled: 0.5
    opacity: enabled ? opacityEnabled : opacityDisabled

    implicitWidth: ViaviStyle.layout.buttonHeight * 5
    implicitHeight: ViaviStyle.layout.buttonHeight

    contentItem:
    Rectangle {
        id: rectangle
        color: button.pressed ? ViaviStyle.colors.selectedColor : ViaviStyle.colors.activeColor
        anchors.fill: parent

        Rectangle {
            anchors.centerIn: parent
            width: icon.visible ? icon.width + text.width : text.width
            Image {
                id: icon
                visible: iconPath.length > 0
                width: visible ? contentItem.height : 0.
                height: contentItem.height
                anchors.verticalCenter: parent.verticalCenter
                fillMode: Image.PreserveAspectFit
                source: iconPath
                mipmap: true
            }

            Text {
                id: text

                anchors.verticalCenter: parent.verticalCenter
                anchors.left:icon.right
                anchors.leftMargin: ViaviStyle.layout.smallMargin
                width: contentWidth
                text: button.text
                font: ViaviStyle.layout.activeBoldTextFont
                color: ViaviStyle.colors.activeItemTextColor
            }
        }
    }
}
