import QtQuick 2.3
import QtQuick.Layouts 1.2
import QtQuick.Controls 2.2

import com.viavi.style 1.0

Rectangle {
    id: setupLayout

    //title container
    default property alias titleContainerData: titleContainer.data
    property alias titleContainerSpacing: titleContainer.spacing
    property alias selectedPageButton: titleContainer.selectedPageButton
    property double titleContainerWidth: setupLayout.width * 0.2 //TODO: a size based on font dimensions might be better

    property Component popupContentItem

    visible: true

    function getFirstPageButton(){
        for (var i = 0; i < titleContainer.data.length; ++i) {
            var pButton = titleContainer.data[i];
            if(pButton instanceof PageButton){
               return pButton;
            }
        }
        return null;
    }

    MouseArea{
        anchors.fill: parent
    }
    Component.onCompleted: {
        selectedPageButton = getFirstPageButton();
    }

    RowLayout {
        anchors.fill: parent
        spacing: 0

       // Left Side (softkeys)
        Rectangle {
           id: leftContainer
           implicitWidth: titleContainerWidth
           Layout.fillHeight: true
           color: ViaviStyle.colors.pageBackgroundColor

           ColumnLayout {
               property PageButton selectedPageButton: null
               spacing: 0

               id: titleContainer
               anchors.fill: parent
           }

           VerticalSeparator {
               x: leftContainer.width
           }
        }

        ScrollView {
            id: flickableDecorator

            Layout.fillHeight: true
            Layout.fillWidth: true
            Layout.margins: ViaviStyle.layout.largeMargin
            
            implicitWidth: setupLayout.width - titleContainerWidth - 2 * Layout.margins
            ScrollBar.horizontal.policy: ScrollBar.AlwaysOff
            
            Flickable {
                id: flickable
                anchors.fill: parent
                contentWidth: flickableDecorator.width
                contentHeight: rightContainer.implicitHeight
                flickableDirection: Flickable.VerticalFlick
                Loader {
                    id: rightContainer

                    source: selectedPageButton.fullPageQmlPath
                    width: flickableDecorator.width
                }
                boundsBehavior: Flickable.StopAtBounds
            }
        }
    }

    Loader {
        id: popupLoader
        sourceComponent: popupContentItem
        anchors.fill: parent
        visible: false
    }
}

