import QtQuick 2.7
import QtQuick.Controls 2.0

RadioButton {
    id: c1
    width: parent.height
    spacing: 3
    leftPadding: 3

    indicator: Rectangle {
        implicitWidth: parent.height
        implicitHeight: parent.height
        height: implicitHeight
        width: implicitWidth
        x: c1.leftPadding
        y: parent.height / 2 - height / 2
        radius: 13
        border.color: "black"

        Rectangle {
            width: parent.height /2
            height: parent.height /2
            x: parent.height / 4
            y: parent.height / 4
            radius: 7
            color: "black"
            visible: c1.checked
        }
    }

    contentItem: Text {
        text: c1.text
        font: c1.font
        color: "white"
        verticalAlignment: Text.AlignVCenter
        leftPadding: c1.indicator.width + c1.spacing
    }
}
