import QtQuick 2.5
import QtQuick.Controls 2.0
import QtQuick.Layouts 1.2

import com.viavi.style 1.0

//TODO: this can be unified with FixMessagePopup too!
Popup {
    id: popup

    property string titleString: ''
    default property alias content: contentData.data
    property int borderSize: ViaviStyle.layout.mediumMargin
    property color backgroundColor: ViaviColor.popupBackgroundColor

    //TODO: This is a workaround getting the same functionality of Overlay.overlay from Qt 5.10. Replace when upgrading Qt
    property Item overlayReplacer: null

    margins: 0
    padding: ViaviStyle.layout.smallMargin

    background: Rectangle {
        anchors.fill: parent
        color: backgroundColor
    }

    ColumnLayout {
        id: mainArea
        anchors.fill: parent

        Layout.fillHeight: true
        Layout.fillWidth: true

        Item {
            id: headerAndCloseButton
            Layout.fillWidth: true
            height: ViaviStyle.layout.buttonHeight
            implicitHeight: ViaviStyle.layout.buttonHeight
            anchors.margins: borderSize

            Text {
                id: headerText
                font: ViaviStyle.layout.titleTextFont
                text: titleString
                horizontalAlignment: Text.AlignHCenter
                verticalAlignment: Text.AlignVCenter
                anchors.centerIn: parent
                color: ViaviColor.mainInfoColor
            }

            ImageButton {
                id: closeButton
                anchors.right: parent.right
                //TODO!
                source: ViaviStyle.images.iconClose
                onClicked: {
                    popup.close()
                }
            }
        }
        Column {
            id: contentData

            spacing: ViaviStyle.layout.smallMargin
        }
    }
}

