import QtQuick 2.9
import QtQml 2.7
pragma Singleton

Item {
    id: root

    property bool dark: false

    Component.onCompleted: {
        root.dark = systemsettings.get("desktop/theme") == "dark"
    }

    Connections {
        target: systemsettings
        function onValueChanged(id, value) {
            if(id === "desktop/theme")
            {
                root.dark = systemsettings.get("desktop/theme") == "dark"
            }
        }
    }


    property color background: (dark)?(ViaviThemeDark.background):(ViaviThemeLight.background)
    property color foreground: (dark)?(ViaviThemeDark.foreground):(ViaviThemeLight.foreground)
    property color border: (dark)?(ViaviThemeDark.border):(ViaviThemeLight.border)
    property color borderFocused: (dark)?(ViaviThemeDark.borderFocused):(ViaviThemeLight.borderFocused)

    // Clickable items
    property color clickableBackground: (dark)?(ViaviThemeDark.clickableBackground):(ViaviThemeLight.clickableBackground)
    property color clickableForeground: (dark)?(ViaviThemeDark.clickableForeground):(ViaviThemeLight.clickableForeground)
    property color clickableBackgroundDisabled: (dark)?(ViaviThemeDark.clickableBackgroundDisabled):(ViaviThemeLight.clickableBackgroundDisabled)
    property color clickableForegroundDisabled: (dark)?(ViaviThemeDark.clickableForegroundDisabled):(ViaviThemeLight.clickableForegroundDisabled)
    property color clickableBackgroundPressed: (dark)?(ViaviThemeDark.clickableBackgroundPressed):(ViaviThemeLight.clickableBackgroundPressed)
    property color clickableForegroundPressed: (dark)?(ViaviThemeDark.clickableForegroundPressed):(ViaviThemeLight.clickableForegroundPressed)

    // Highlighted clickable items
    property color highlightedBackground: (dark)?(ViaviThemeDark.highlightedBackground):(ViaviThemeLight.highlightedBackground)
    property color highlightedForeground: (dark)?(ViaviThemeDark.highlightedForeground):(ViaviThemeLight.highlightedForeground)

    // Status
    property color fail: (dark)?(ViaviThemeDark.fail):(ViaviThemeLight.fail)
    property color pass: (dark)?(ViaviThemeDark.pass):(ViaviThemeLight.pass)
    property color warning: (dark)?(ViaviThemeDark.warning):(ViaviThemeLight.warning)


}
