import QtQuick 2.9
pragma Singleton

QtObject {
    id: root

    // Source: https://viavicentral.viavisolutions.com/docs/DOC-6212

    // Primary Color
    readonly property color viaviPurple: "#500778"
    readonly property color darkBlue:    "#0040a6"
    readonly property color mediumBlue:  "#426da9"
    readonly property color lightBlue:   "#00a9e0"
    readonly property color blueGreen:   "#00b0a2"

    // Secondary Color
    readonly property color burgundy:   "#8a1b61"
    readonly property color red:        "#d50032"
    readonly property color orange:     "#e87722"
    readonly property color yellow:     "#ffb500"
    readonly property color green:      "#2cb34a"

    // Tertiary colors
    readonly property color darkGray:   "#333333"
    readonly property color mediumGray: "#999999"
    readonly property color lightGray3: "#c6c6c6"
    readonly property color lightGray2: "#dbdbdb"
    readonly property color lightGray1: "#f2f2f2"
    readonly property color darkerBlue: "#1a2b58"
    readonly property color deepBlue:   "#000c2b"
    readonly property color black:      "#000000"
    readonly property color white:      "#ffffff"

    // Tranparent color
    readonly property color transparent: "transparent"

    // Colors not from the ViaviCentral document
    readonly property color viaviLightPurple: "#911eb4"

    /// @brief Change alpha value of the color
    /// @param[in] color Color to change
    /// @param[in] alpha New alpha value (0 transparent, 1 opaque)
    /// @return color with new alpha value
    function changeTransparent(color, alpha){
        return Qt.rgba(color.r, color.g, color.b, alpha)
    }

    function getColor(alarm) {
        switch(alarm) {
        case -2:
            return warningColor
        case -1:
            return failedColor
        case 1:
            return passColor
        default:
            return noTestColor
        }
    }


    function getTextColor(alarm) {
        switch(alarm) {
        case -2:
            return warningColor
        case -1:
            return failedColor
        case 1:
            return passColor
        default:
            return mainInfoColor
        }
    }

    //NOTE: Names from ViaviColor.qml of Util_Ui_Qt. Some of them may need to be separated to a "Fiber Style".
    property color contentBackgroundColor: white // background for items you might expect to display some info like text ...
    property color pageBackgroundColor: "#eeeeee" // background for large items like a main page, could be used as contrast for internal items
    property color disabledBackgroundColor: "#88dddddd" //disabled items should use this a background
    property color transparentBackgroundColor: "#88888888" // background for modal dialog so that the element behind can be seen
    property color popupBackgroundColor: '#CC888888' //less transparet background for use in popups
    property color alternativeBackgroundColor: "#F2F2F2" // alternative background color to be used to obtain contrast with contentBackgroundColor
    property color selectedBackgroundColor: mediumGray
    property color deselectedBackgroundColor: lightGray2

    property color borderColor: "#D8D8D8"
    property color separatorColor: borderColor
    property color borderHighContrastColor: 'crimson'

    property color mainInfoColor: "#000000" // to be used by all important to show all important information
    property color secondaryInfoColor: "#5A5A5A" // to be used to display lower impotance information, like table header, value description ...
    property color activeColor: viaviPurple //to be used by elements that the user can interact with like buttons ...
    property color selectedColor: "#8451a0" // color for active item that are selected/checked (active item uses activeColor)
    property color menuSelectionColor: "#aaaaaa" // menu item that is selected
    property color activeItemTextColor: white // to be used for contrast on items that use active color backround or other heavy background color
    property color disabledItemColor: "#AEAEAE" // to be used for contrast on items that use active color backround or other heavy background color
    property color checkedItemColor: "#30C8FF"
    property color extraTraceEventColor: "#f58231"

    property color passColor: green
    property color failedColor: "#BF002C"
    property color warningColor: "#ED9B40"
    property color noTestColor: disabledItemColor

    property color passLevelMarkColor: "blue"


    //NOTE: colours even more specific to FiberOptic
    //specific colors
    property color tableBackgroundColor: "slategrey"

    property color blueCursorColor: "blue"
    property color redCursorColor: "red"

    property color keyboardButtonCustomColor: "#D1D5DC"

    property color menuSelectionMarkerColor: '#0099ee'

    property color sourceColor: 'midnightblue'
    property color powermeterColor: 'mediumblue'

    property color slmPurple: '#9D70C1'

    //Ordered as to make distinguishing as easy as possible.
    property var traceColors: [
        // Colours from https://sashamaps.net/docs/resources/20-colors/
        '#e6194B', // Red
        '#3cb44b', // Green
        '#4363d8', // Blue
        '#f58231', // Orange
        '#42d4f4', // Cyan
        '#f032e6', // Magenta
        '#469990', // Teal
        '#dcbeff', // Lavender
        '#9A6324', // Brown
        '#bfef45', // Lime
        '#ffe119', // Yellow
        '#fabed4', // Pink
        '#fffac8', // Beige
        '#800000', // Maroon
        '#aaffc3', // Mint
        '#808000', // Olive Green
        '#ffd8b1', // Apricot
        '#000075', // Navy
        '#a9a9a9', // Grey
        '#911eb4', // Purple

        // Rest of colours from the X11 version
        "#FF4000", // RGB 255  64   0 // Vermilion (briliant orange red)
        "#64A464", // Aqua forest (light green)
        "#30C8FF", // RGB  48 200 255 // Azure (light blue)
        "#DF60FF", // RGB 223  96 255 // Heliotrope (pink purple, faded pink)
        "#FFC000", // RGB 255 192   0 // Amber (between yellow and orange)
        "#FF69B4", // Hot Pink
        "#FFA500", // Orange
        "#006400", // Dark Green
        "#FFD700", // Gold
        "#4B0082", // Indigo
        "#00FFFF", // Cyan
        "#FA8072", // Salmon
        "#008000", // RGB   0 128   0 // Japanese laurel (green)
        "#4040FF", // RGB  64  64 255 // Blue
        "#004080", // RGB   0  64 128 // Navy blue of sorts
        "#a03030", // RGB 160  48  48 // Stiletto (dark red)
        "#Ae8e8e", // Del Rio (brown)
        "#4545A5", // Gigas (light indigo)
        "#FFB500", // Yellow
        "#426DA9", // Medium Blue
        "#2CB34A", // Dark Green
        "#A96BCB", // Amethyst (Light Purple)
        "#A0522D", // Sienna
        "#191970", // Midnight Blue
        "#708090", // Slate Grey
        "#C0C0C0", // Silver
        "#8888C8", // Blue Bell (pale violet)
        "#8888C8"]

    readonly property real opacityEnabled: 1.0
    readonly property real opacityDisabled: 0.5
}
