import QtQuick 2.3

import com.viavi.style 1.0

Rectangle {
    id: sliderContainer
    
    property int ratio: 50 // 0 to 100, ratio size of parent
    property int value: 0 // 0 to 100, position of the slider
    property variant orientation : Qt.Vertical
    
    onValueChanged: updatePos();    
    
    Component.onCompleted: {
    	ratio = checkValue(ratio, 0, 100);	
    	value = checkValue(value, 0, 100);	
    }    
    
    function checkValue(val, min, max) {    	
	  if(val > max)
	  {
	  val = max;
	  }
	  else if(val < min)
	  {
	  val = min;
	  }
	  return val;
    }
    
    function updatePos() {
    	var length = (orientation == Qt.Vertical ? sliderContainer.height : sliderContainer.width);
    	var max = length * ( (100 - ratio) / 100 );
    	var min = 0;
    	var pos = value * length / 100;    
    	
    	pos = checkValue(pos, min, max);	

    	if(orientation == Qt.Vertical)
	    {
	    slider.y = pos;
	    }
    	else
	    {
	    slider.x = pos;
	    }
    }

    width: 20
    height: 100

    color: ViaviStyle.colors.secondaryInfoColor
    border.color: ViaviStyle.colors.secondaryInfoColor
    border.width: 4

    radius: 2
    
    clip: true
    
    visible: true

    Rectangle {
        id:slider

        width: orientation != Qt.Vertical ? sliderContainer.width * ( Math.max( ratio, 5 ) ) / 100 : sliderContainer.width
        height: orientation == Qt.Vertical ? sliderContainer.height * ( Math.max( ratio, 5 ) ) / 100 : sliderContainer.height

        radius: 2

        color: ViaviStyle.colors.lightGray2

        MouseArea {
            anchors.fill: parent; drag.target: parent
            
            drag.axis: orientation == Qt.Vertical ? Drag.YAxis : Drag.XAxis;
            drag.minimumX: 0;
            drag.minimumY: 0;
            drag.maximumY: sliderContainer.height - slider.height;
            drag.maximumX: sliderContainer.width - slider.width;
            
            onPositionChanged: {
            	var valueMax = 100 - ratio;
            	var valueTemp = (orientation == Qt.Vertical ? slider.y * 100 / sliderContainer.height : slider.x * 100 / sliderContainer.width); 
            	var length = (orientation == Qt.Vertical ? sliderContainer.height : sliderContainer.width);
				   valueTemp = checkValue(valueTemp, 0, valueMax);	           		
            	value = parseInt(valueTemp, 10); 
            }
        }
    }
}
