import QtQuick 2.7
import QtQuick.Controls 2.0
import QtQuick.Window 2.2

import com.viavi.style 1.0
import com.viavi.style.components 1.0
import com.viavi.fiberutilui.components 1.0

ListView {
    id: menuOptionsListView

    anchors.fill: parent

    property QtObject prevLevelMenu: null
    property Menu nextLevelMenu: null
    property bool isNextLevelMenuOpened: false
    property bool isChoiceEditorOpened: false

    property alias choiceColumnWidth: choiceEditor.columnWidth
    property alias choiceMaxColumnWidth: choiceEditor.maxColumnWidth

    property Item menuContainer

    property int actionAlignY: 0

    clip:true
    focus:true
    keyNavigationWraps: true

    function selectNextAvailable() {
        var startIndex = currentIndex
        if (currentIndex === -1 && count > 0) {
            currentIndex = 0
            startIndex = currentIndex
            if (currentItem.activable()) {
                return
            }
        }

        do {
            incrementCurrentIndex()
        }  while (currentItem && (!currentItem.activable()) && currentIndex !== startIndex)
    }
    function selectPrevAvailable() {
        var startIndex = currentIndex
        if (currentIndex === -1 && count > 0) {
            currentIndex = count - 1
            startIndex = currentIndex
            if (currentItem.activable()) {
                return
            }
        }

        do {
            decrementCurrentIndex()
        }  while (currentItem && (!currentItem.activable()) && currentIndex !== startIndex)
    }

    Keys.onUpPressed: {
        if (currentItem) {
            currentItem.handleExited()
        }
        selectPrevAvailable()
        if (currentItem) {
            currentItem.handleEntered()
        }
    }

    Keys.onDownPressed: {
        if (currentItem) {
            currentItem.handleExited()
        }
        selectNextAvailable()
        if (currentItem) {
            currentItem.handleEntered()
        }
    }

    Keys.onReturnPressed: {
        currentItem.activate(true)
    }

    Keys.onLeftPressed: currentItem.activate(true)

    Keys.onEscapePressed: {
        close()
    }

    onVisibleChanged: {
        if (!visible) {
            focus = false
            if (prevLevelMenu) {
                prevLevelMenu.forceActiveFocus()
            }
            if( isChoiceEditorOpened ) {
                choiceEditor.close();
                isChoiceEditorOpened = false;
            }
        }
        else {
            menuOptionsListView.forceActiveFocus()
        }
    }

    onMovementStarted: {
        if( (currentItem !== null ) && ( isChoiceEditorOpened || isNextLevelMenuOpened )) {
            currentItem.activate( false )
        }
    }

    ChoiceEditor {
        id: choiceEditor

        menuContainer: menuOptionsListView.menuContainer

        selectedMenuLine: menuOptionsListView.currentItem
    }

    // currentIndex: menu_cfg_currentLineIndex.value

    // Make sure currentIndex is synchronized with the C++ value
    Connections {
        target: menu_cfg_currentLineIndex
        function onValueChanged() {
        	currentIndex = menu_cfg_currentLineIndex.value
        }
    }

    boundsBehavior: Flickable.StopAtBounds

    /* close menus if model count is 0 */
    /* this helps us cleanup when changes are triggered by backend */
    onCountChanged:
    {
        if ( menuOptionsListView.count === 0)
        {
            choiceEditor.close()
            isChoiceEditorOpened = false;
            if( nextLevelMenu !== null)
            {
                nextLevelMenu.close()
                isNextLevelMenuOpened = false;
            }
        }
    }

    delegate: Item{
        id: itemId

        property bool hovered: false
        width: ListView.view.width
        implicitWidth: ListView.view.width
        height: ViaviStyle.layout.menuLineHeight
        implicitHeight: ViaviStyle.layout.menuLineHeight
        Loader{
            active: model.lineType !== menu_res_lineType.enums.ecLine_Titre

            sourceComponent: Component{

                MenuLineItem{

                    lineStatus: model.lineStatus
                    lineType: model.lineType
                    lineCursorEffect: model.lineCursorEffect
                    lineLeftLabel: model.lineLeftLabel
                    lineRightLabel: model.lineRightLabel
                    lineNumber: model.lineNumber
                    lineIndex: model.lineIndex

                    width: itemId.width
                    height: itemId.height

                    onClicked: {
                        itemId.handleClick()
                    }
                }
            }
        }

        Loader{
            active: model.lineType === menu_res_lineType.enums.ecLine_Titre
            sourceComponent: Component{

                Button {
                    text: model.lineLeftLabel
                    
                    textHorizontalAlignment: Text.AlignRight
                    textAnchors.rightMargin: ViaviStyle.layout.largeMargin
                    
                    width: itemId.width
                    height: itemId.height

                    enabled: model.lineStatus !== menu_res_lineState.enums.ecMenu_Color_Grey
                    opacity: 1.0

                    Rectangle {
                        id: disableOverlay

                        anchors.fill: parent

                        color: ViaviStyle.colors.disabledBackgroundColor
                        opacity: 0.5

                        visible: !enabled
                    }

                    Item{
                        anchors.left: parent.left
                        anchors.top: parent.top
                        anchors.bottom: parent.bottom
                        anchors.topMargin: ViaviStyle.layout.smallMargin
                        anchors.bottomMargin: ViaviStyle.layout.smallMargin
                        anchors.leftMargin: ViaviStyle.layout.largeMargin
                        width: height

                        Image{
                            anchors.fill: parent
                            fillMode: Image.PreserveAspectFit

                            source: model.lineIcon
                        }
                    }

                    Rectangle{
                        anchors.bottom: parent.bottom
                        width: parent.width

                        color: ViaviStyle.colors.separatorColor
                        height: ViaviStyle.layout.separatorSize
                    }

                    Rectangle {
                        id: enteredHighlight
                        color: ViaviStyle.colors.menuSelectionColor
                        anchors.fill: parent
                        visible: itemId.hovered
                        opacity: 0.5
                    }

                    onClicked: {
                        itemId.handleClick()
                    }
                }
            }


        }

        function handleEntered() {
            if(model.lineType !== menu_res_lineType.enums.ecLine_Titre){
                //For title line this is handle by the titleItemAction.
                //the action is needed because the action needs to happen anytime the line is pressed. even if the line index is the current index
                menu_cfg_selectedLine.value = model.lineNumber
            }
            hovered = true
        }

        function handleExited() {
            hovered = false
        }

        function activable() {
            return lineStatus !==  menu_res_lineState.enums.ecMenu_Color_Grey
        }

        function activate(newLine) {
            focus = true
            menuOptionsListView.currentIndex = index

            if(model.lineType !== menu_res_lineType.enums.ecLine_Titre){
                //For title line this is handle by the titleItemAction.
                //the action is needed because the action needs to happen anytime the line is pressed. even if the line index is the current index
                menu_cfg_selectedLine.value = model.lineNumber
            }

            if ( model.lineType !== menu_res_lineType.enums.ecLine_Titre ) {
                menu_cfg_currentLineIndex.value = model.lineIndex;
            }

            var wasChoiceEditorOpened = isChoiceEditorOpened
            if( isChoiceEditorOpened ) {
                choiceEditor.close();
                isChoiceEditorOpened = false;
            }

            var wasNextLevelMenuOpened = isNextLevelMenuOpened
            if( isNextLevelMenuOpened && nextLevelMenu !== null ) {
                nextLevelMenu.close();
                isNextLevelMenuOpened = false;
            }

            if ( model.lineType === menu_res_lineType.enums.ecLine_Standard) {
                if(newLine || !wasChoiceEditorOpened) {
                    choiceEditor.open();
                    isChoiceEditorOpened = true;
                }
            }
            else if (model.lineType === menu_res_lineType.enums.ecLine_Subwin) {
                if(nextLevelMenu !== null
                        && (newLine || !wasNextLevelMenuOpened)) {
                    nextLevelMenu.open();
                    isNextLevelMenuOpened = true;
                }
            }else if(model.lineType === menu_res_lineType.enums.ecLine_Titre){
                menu_act_titleItemAction.invokeWithStringArg(model.lineNumber)
            }
        }

        function handleClick() {
            focus = true

            var newLine = false
            if(menu_cfg_selectedLine.value !== model.lineNumber){
                newLine = true
            }

            activate(newLine)
        }

    }


}

