import QtQuick 2.5
import QtQuick.Controls 2.0

import com.viavi.style 1.0
import com.viavi.style.components 1.0
import com.viavi.fiberutilui 1.0

Item {
    id: lineDelegate

    property int lineStatus
    property int lineType
    property int lineCursorEffect
    property string lineLeftLabel
    property string lineRightLabel
    property int lineNumber
    property int lineIndex

    signal clicked()

    /* line information rectangle */
    Rectangle {
        id: optionLineRectangle

        width: parent.width
        height: parent.height

        anchors.bottom: parent.bottom

        property bool isHovered: false
        property bool isSelectionAncestor: lineDelegate.lineCursorEffect === menu_res_lineState.enums.ecMenu_Color_Selected ||
                                           lineDelegate.lineCursorEffect === menu_res_lineState.enums.ecMenu_Color_Parent_Selected
        color: (isHovered || isSelectionAncestor) ? ViaviStyle.colors.menuSelectionColor : ViaviStyle.colors.contentBackgroundColor

        border.color: ViaviStyle.colors.borderColor
        border.width: ViaviStyle.layout.borderSmallWidth
    }

    ColorImage {
        id: selectionMarker
        visible: lineDelegate.lineType !== menu_res_lineType.enums.ecLine_Titre
                 && optionLineRectangle.isSelectionAncestor

        width: ViaviStyle.layout.largeMargin
        height: ViaviStyle.layout.largeMargin

        anchors.left: parent.left
        anchors.verticalCenter: parent.verticalCenter

        source: FiberStyle.images.iconMenuArrow
        fillMode: Image.PreserveAspectFit
        smooth: true
        color: ViaviStyle.colors.menuSelectionMarkerColor
    }

    Text {
        id: leftLabel

        visible: lineDelegate.lineType !== menu_res_lineType.enums.ecLine_Titre

        anchors.top: optionLineRectangle.top
        anchors.topMargin: ViaviStyle.layout.smallMargin
        anchors.left: selectionMarker.right
        anchors.right: parent.right

        horizontalAlignment: Text.AlignLeft
        verticalAlignment: Text.AlignTop

        text: lineDelegate.lineLeftLabel
        color:  ViaviStyle.colors.mainInfoColor
        font : lineDelegate.lineStatus === menu_res_lineState.enums.ecMenu_Color_Grey ?
                   ViaviStyle.layout.infoTextFont : ViaviStyle.layout.activeTextFont
        wrapMode: Text.NoWrap
        elide: Text.ElideRight
    }

    Text {
        id: righLabel

        visible: lineDelegate.lineType !== menu_res_lineType.enums.ecLine_Titre

        anchors.bottom: optionLineRectangle.bottom
        anchors.bottomMargin: ViaviStyle.layout.smallMargin
        anchors.left: leftLabel.left
        anchors.right: parent.right

        horizontalAlignment: Text.AlignLeft
        verticalAlignment: Text.AlignBottom

        text: lineDelegate.lineRightLabel
        color: lineDelegate.lineStatus === menu_res_lineState.enums.ecMenu_Color_Grey ?
                   ViaviStyle.colors.mainInfoColor : ViaviStyle.colors.activeColor
        font : lineDelegate.lineStatus === menu_res_lineState.enums.ecMenu_Color_Grey ?
                  ViaviStyle.layout.infoTextFont : ViaviStyle.layout.activeBoldTextFont
        wrapMode: Text.NoWrap
        elide: Text.ElideRight
    }

    Rectangle {
        id: disbleOverlay

        anchors.fill: parent
        anchors.margins: optionLineRectangle.border.width

        color: ViaviStyle.colors.disabledBackgroundColor

        visible: lineDelegate.lineStatus === menu_res_lineState.enums.ecMenu_Color_Grey
    }


    MouseArea {
        id: lineMouseArea

        anchors.fill: optionLineRectangle

        enabled: lineDelegate.lineStatus !== menu_res_lineState.enums.ecMenu_Color_Grey

        hoverEnabled: true

        onClicked: {
            lineDelegate.clicked();
        }

        onEntered: {
            optionLineRectangle.isHovered = true
        }
        onExited: {
            optionLineRectangle.isHovered = false
        }
    }
}
