import QtQuick 2.3
import QtQuick.Layouts 1.1

import com.viavi.style 1.0
import com.viavi.style.components 1.0
import com.viavi.style.components.virtualkeyboard 1.0
import com.viavi.fiberutilui 1.0
import com.viavi.fiberutilui.Util_Ui_Qt 1.0

FocusScope {
    id: mainPage
    anchors.fill: parent

    default property alias mainAreaData: mainArea.data
    property alias fileExplorerDetailsData: fileExplorerDetailsContainer.data
    property alias fullScreenData: fullScreenContainer.data
    property bool softkeysVisible: true
    property alias fileBrowserEnabled: filebrowserLoader.enabled
    property alias useSystemKeyboard: keyboard.useSystemKeyboard

    function dialogIconPath()
    {
        switch(dialog_res_iconType.value){
        case dialog_res_iconType.enums.ecW_Stop:
            return FiberStyle.images.iconsCustomIsuPath + "Dialog_Icon_Stop.png"
        case dialog_res_iconType.enums.ecW_Warn:
            return FiberStyle.images.iconsCustomIsuPath + "Dialog_Icon_Warning.png"
        case dialog_res_iconType.enums.ecW_Error:
            return FiberStyle.images.iconsCustomIsuPath + "Dialog_Icon_Error.png"
        case dialog_res_iconType.enums.ecW_Info:
            return FiberStyle.images.iconsCustomIsuPath + "Dialog_Icon_Info.png"
        case dialog_res_iconType.enums.ecW_Comms:
            return FiberStyle.images.iconsCustomIsuPath + "Dialog_Icon_Comms.png"
        case dialog_res_iconType.enums.ecW_Pass:
            return FiberStyle.images.iconsCustomIsuPath + "Dialog_Icon_Pass.png"
        case dialog_res_iconType.enums.ecW_Fail:
            return FiberStyle.images.iconsCustomIsuPath + "Dialog_Icon_Fail.png"
        default:
            return ""
        }
    }

    Rectangle {
        id: root
        anchors.fill: parent

        color: "white"

        RowLayout {
            id: explorerAndSoftkeysLayout
            anchors.fill: parent

            spacing: 0

            Item {
                id: mainAreaParent
                Item{
                    id: mainArea

                    anchors.fill: parent
                }

                Layout.fillHeight: true
                Layout.fillWidth: true

                FiberSetup {
                    width: parent.width
                    height: parent.height

                    visible: menu_res_visible.value
                    firstMenuYAlign: softkeys.getSoftkeyYByIndex(menu_res_alignToSoftkeyIndex.value)
                }

                ColumnLayout{

                    visible: filebrowser_res_visible.value

                    anchors.fill: parent

                    Column{
                        id: fileExplorerDetailsContainer

                        Layout.fillWidth: true
                    }

                    Loader{
		    	id: filebrowserLoader
                        Layout.fillHeight: true
                        Layout.fillWidth: true

                        source: "../Util_Ui_Qt/Util_Gui/Gui_File_Explorer/Qml/File_Explorer.qml"
                        enabled: true
                        visible: filebrowser_res_visible.value
                    }
                }

            }

            Softkeys{
                id: softkeys
                visible: softkeysVisible
                Layout.fillHeight: true
                implicitWidth: ViaviStyle.layout.softKeysWidth
            }
        }

        Item{
            id: fullScreenContainer

            anchors.fill: parent
        }

        Keyboard {
            id: keyboard
            visible: keyboard_res_enabled.value
        }

        Dialog {

            visible: dialog_res_enabled.value

            titleText: dialog_res_idText.value
            text: dialog_res_mainText.value
            exitText:  dialog_res_exitText.value
            iconSource: dialogIconPath()
            button1Text: dialog_res_button1Text.value
            button2Text: dialog_res_button2Text.value
            deaf: dialog_res_deaf.value
            dialogType: dialog_res_type.value

            onButton1Action: {
                dialog_act_button1Action.invoke()
            }

            onButton2Action: {
                dialog_act_button2Action.invoke()
            }

            onUserActionClose: {
                dialog_act_userCloseAction.invoke()
            }
        }
    }
}
