import QtQuick 2.5
import QtQuick.Controls 2.0
import QtQuick.Window 2.2

import com.viavi.style 1.0
import com.viavi.style.components 1.0
import com.viavi.style.components.virtualkeyboard 1.0


Popup {
    id: keyboard

    property alias useSystemKeyboard: systemKeyboard.visible

    //Popup closing passes focus back to parent, but in Fiber the caller is generally not a parent, e.g. file manager, menus.
    property var previousFocus: null
    onAboutToShow: {
        previousFocus = keyboard.parent.Window.window.activeFocusItem
    }
    onAboutToHide: {
        if (previousFocus) {
            previousFocus.forceActiveFocus()
        }
    }

    KeyboardUtils { id: keyboardUtils }

    width: parent.width
    height: parent.height
    x:0
    y:0

    background: Rectangle{

        anchors.fill: parent

        color: ViaviColor.transparentBackgroundColor
    }

    modal: true

    closePolicy: Popup.NoAutoClose

    contentItem: Item {

        anchors.fill: parent

        LegacyKeyboardNumerical {
            visible: !systemKeyboard.visible && (keyboard_res_type.value === keyboard_res_keyboardType.enums.ecNum_Keyboard
                        || keyboard_res_type.value === keyboard_res_keyboardType.enums.ecDate_Time_Keyboard
                        || keyboard_res_type.value === keyboard_res_keyboardType.enums.ecPassword_Keyboard)

        }

        LegacyKeyboardAlpha {
            visible:   !systemKeyboard.visible && ( keyboard_res_type.value === keyboard_res_keyboardType.enums.ecFile_Name_Keyboard
                       || keyboard_res_type.value === keyboard_res_keyboardType.enums.ecComplete_Keyboard
                       || keyboard_res_type.value === keyboard_res_keyboardType.enums.ecAuto_File_Name_Keyboard
                       || keyboard_res_type.value === keyboard_res_keyboardType.enums.ecAuto_Dir_Name_Keyboard )

        }

        KeyboardTextFild {
            id: systemKeyboard

            visible: false
        }
    }
}

