import QtQuick 2.5
import QtQuick.Controls 2.0

import com.viavi.style 1.0
import com.viavi.style.components 1.0
import com.viavi.fiberutilui 1.0

Popup{

    id: root

    property alias model: listView.model
    property alias delegate: listView.delegate
    property int currentIndex: listView.currentIndex
    property alias titleText: titleTextId.text

    signal cancelClicked()
    signal validateClicked()

    width: parent.width
    height: parent.height
    x: 0
    y: 0

    background: Rectangle{

        anchors.fill: parent

        color: ViaviStyle.colors.transparentBackgroundColor
    }

    contentItem: Item {

        anchors.fill: parent

        BasicContainer {
            id: mainContainer
            width: ViaviStyle.layout.smallPopupWidth
            height: Math.min(parent.height,
                             titleBox.height + buttonBox.height
                             + 2 * ViaviStyle.layout.smallMargin
                             + listView.count * ViaviStyle.layout.buttonHeight)


            anchors.horizontalCenter: parent.horizontalCenter
            anchors.verticalCenter: parent.verticalCenter

            BasicContainer {
                id: titleBox

                property int noOfTextRows: Math.ceil( ViaviStyle.layout.titleTextFontMetrics.advanceWidth( titleTextId.text ) / width )

                width: parent.width
                height: Math.max ( noOfTextRows * ( ViaviStyle.layout.titleTextFontMetrics.height + ViaviStyle.layout.mediumMargin )
                                   + 2 * ViaviStyle.layout.smallMargin, ViaviStyle.layout.buttonHeight + 2 * ViaviStyle.layout.smallMargin )
                anchors.top: parent.top

                Text {
                    id: titleTextId
                    anchors.centerIn: parent

                    width: parent.width

                    font: ViaviStyle.layout.titleTextFont
                    color: ViaviStyle.colors.mainInfoColor

                    horizontalAlignment: Text.AlignHCenter
                    wrapMode: Text.WordWrap
                }
            }

            Item {
                id: listContainer

                anchors.top: titleBox.bottom
                anchors.bottom: buttonBox.top
                anchors.left: parent.left
                anchors.right: parent.right
                anchors.margins: ViaviStyle.layout.smallMargin

                clip:true

                ListView {
                    id: listView

                    currentIndex: root.currentIndex


                    anchors.fill: parent

                    boundsBehavior: Flickable.StopAtBounds

                    highlightFollowsCurrentItem: true
                    highlightMoveVelocity: -1
                    highlightMoveDuration: -1

                    snapMode: ListView.SnapToItem

                    ScrollBar.vertical: ScrollBar {
                        id: listScrollBar
                        width: ViaviStyle.layout.mediumMargin
                        contentItem: Rectangle {
                            radius: ViaviStyle.layout.smallMargin
                            color: ViaviStyle.colors.borderColor
                        }

                        visible: listView.contentHeight > listView.height
                    }

                    onVisibleChanged: {
                        if( visible )
                        {
                            listView.currentIndex = root.currentIndex
                            listView.positionViewAtIndex( listView.currentIndex , ListView.Center )
                        }
                    }
                }
            }

            BasicContainer{
                id: buttonBox

                width: parent.width
                height: ViaviStyle.layout.buttonHeight + 2 * ViaviStyle.layout.smallMargin

                anchors.bottom: parent.bottom

                ImageButton {
                    id: cancelButton

                    anchors.left: parent.left
                    anchors.leftMargin: parent.width * 0.25
                    anchors.verticalCenter: parent.verticalCenter

                    source: FiberStyle.images.sourceDwdmCancelBtnImg

                    onClicked: root.cancelClicked()
                }

                ImageButton{
                    id: enterButton

                    anchors.right: parent.right
                    anchors.rightMargin: parent.width * 0.25
                    anchors.verticalCenter: parent.verticalCenter

                    source: FiberStyle.images.sourceDwdmEnterBtnImg

                    onClicked: root.validateClicked()
                }
            }
        }
    }
}
