import QtQuick 2.3
import QtQuick.Layouts 1.2
import QtQuick.Controls 2.0

import com.viavi.style 1.0

AbstractButton{
    id: button

    property alias textHorizontalAlignment: textId.horizontalAlignment

    height: ViaviStyle.layout.buttonHeight
    contentItem:
    Rectangle{
        color: button.pressed ? ViaviStyle.colors.selectedColor : "transparent"

        ColumnLayout{
            id: mainArea
            anchors.fill: parent
            anchors.topMargin: ViaviStyle.layout.smallMargin
            anchors.bottomMargin: ViaviStyle.layout.smallMargin
            anchors.leftMargin: ViaviStyle.layout.mediumMargin
            anchors.rightMargin: ViaviStyle.layout.mediumMargin

            Text{
                id: textId

                Layout.fillWidth: true
                Layout.fillHeight: true

                horizontalAlignment: Text.AlignHCenter
                verticalAlignment: Text.AlignVCenter

                text: button.text
                font: button.font
            }

            Item{
                height: ViaviStyle.layout.smallMargin - separatorId.height
            }

            Rectangle{
                id: separatorId

                Layout.fillWidth: true
                height: ViaviStyle.layout.separatorSize

                color: ViaviStyle.colors.activeColor
            }
        }
    }
}
