import QtQuick 2.3
import QtQuick.Layouts 1.2
import QtQuick.Controls 2.0
import QtQuick.Window 2.2


import com.viavi.style 1.0
import com.viavi.style.components 1.0
import com.viavi.fiberutilui 1.0
import com.viavi.fiberutilui.components 1.0


Popup {
    id: dialog

    //Popup closing passes focus back to parent, but in Fiber the caller is generally not a parent, e.g. file manager, menus.
    property var previousFocus: null
    onAboutToShow: {
        previousFocus = dialog.parent.Window.window.activeFocusItem
    }
    onAboutToHide: {
        if (previousFocus) {
            previousFocus.forceActiveFocus()
        }
    }

	// EPT 9755 : Lock CANCEL Hardkey -> ESCAPE signal hiding Popup
    closePolicy: Popup.NoAutoClose

    width: parent.width
    height: parent.height
    x:0
    y:0

    padding: 0

    property int dialogType: dialog_res_type.enums.edt_Classic

    property alias titleText: title.text
    property alias text: description.text
    property alias exitText: exitInfo.text
    property alias iconSource: icon.source
    property alias button1Text: button1.text
    property alias button2Text: button2.text
    property bool deaf: false //ignores user action
    property Item imageItem: icon

    readonly property real scaleFactor: dialogType === dialog_res_type.enums.edt_Classic
                                            ? (ViaviStyle.layout.isSmallScreen ? 1.3 : 1)
                                            : 1
    readonly property int buttonWidth: ViaviStyle.layout.buttonHeight * 3
    readonly property int containerWidth: dialog.width / 2 * scaleFactor
    readonly property int iconColumnPrefferedWidth: containerWidth / 8

    signal button1Action
    signal button2Action
    signal userActionClose

    background: Rectangle{

        anchors.fill: parent

        color: ViaviStyle.colors.transparentBackgroundColor

        MouseArea{
            anchors.fill: parent

            onClicked: {
                if(!buttonRow.visible && !deaf){
                    dialog.userActionClose()
                }
            }
        }
    }

    contentItem:  Item {

        BasicContainer{

            id: container
            x: dialogType === dialog_res_type.enums.edt_Classic
               ? (parent.width - width) / 2
               : dialog_cfg_customX.value
            y: dialogType === dialog_res_type.enums.edt_Classic
                ? (parent.height - height) / 2
                : dialog_cfg_customY.value


            width: dialogType === dialog_res_type.enums.edt_Classic
                    ? dialog.containerWidth
                    : dialog_cfg_customWidth.value
            height: dialogType === dialog_res_type.enums.edt_Classic
                    ? textData.height + 2 * ViaviStyle.layout.mediumMargin * dialog.scaleFactor
                    : dialog_cfg_customHeight.value


            RowLayout{
                anchors.left: parent.left
                anchors.right: parent.right
                anchors.leftMargin: ViaviStyle.layout.mediumMargin
                anchors.rightMargin: ViaviStyle.layout.mediumMargin

                Item{
                    Layout.minimumWidth: icon.width * dialog.scaleFactor
                    Layout.preferredWidth: dialog.iconColumnPrefferedWidth * dialog.scaleFactor
                    height: textData.height
                    Image{
                        id: icon

                        anchors.centerIn: parent
                    }
                    
                    visible: dialog.iconSource.toString().length
                }

                Column{
                    id: textData

                    Layout.fillWidth: true
                    Layout.alignment: Qt.AlignTop
                    Layout.topMargin: ViaviStyle.layout.mediumMargin * dialog.scaleFactor
                    Layout.bottomMargin: ViaviStyle.layout.mediumMargin * dialog.scaleFactor

                    spacing: ViaviStyle.layout.mediumMargin * dialog.scaleFactor

                    Text{
                        id: title

                        width: parent.width
                        height: contentHeight * dialog.scaleFactor

                        horizontalAlignment: Text.AlignLeft

                        wrapMode: Text.Wrap

                        font: ViaviStyle.layout.activeTextFont
                    }


                    Text{
                        id: description

                        width: parent.width

                        height: contentHeight * dialog.scaleFactor

                        horizontalAlignment: Text.AlignLeft

                        wrapMode: Text.Wrap

                        font: ViaviStyle.layout.titleTextFont
                    }

                    Item{
                        id: buttonsSeperator
                        height: dialogType === dialog_res_type.enums.edt_Classic
                                    ? ViaviStyle.layout.buttonHeight * dialog.scaleFactor
                                    : Math.max(0,
                                         dialog_cfg_customHeight.value - title.height - description.height - exitInfo.height - buttonRow.height - 5 * textData.spacing)
                        width: 1 //just make sure it's not 0
                    }

                    Text {
                        id: exitInfo

                        height: contentHeight * dialog.scaleFactor
                        width: parent.width

                        horizontalAlignment: Text.AlignHCenter

                        font: ViaviStyle.layout.activeTextFont
                        
                        wrapMode: Text.WordWrap

                        visible: text.length > 0
                    }

                    Row {
                        id: buttonRow

                        height: ViaviStyle.layout.buttonHeight
                        anchors.right: parent.right
                        anchors.margins: ViaviStyle.layout.mediumMargin
                        spacing: ViaviStyle.layout.mediumMargin

                        visible: button1.text.length > 0 || button2.text.length > 0

                        Button{
                            id: button1

                            width: dialog.buttonWidth
                            height: parent.height

                            visible: text.length > 0

                            onClicked:{
                                if(!dialog.deaf){
                                    dialog.button1Action()
                                }
                            }
                        }

                        Button{
                            id: button2
                            width: dialog.buttonWidth
                            height: parent.height

                            visible: text.length > 0

                            onClicked:{
                                if(!dialog.deaf){
                                    dialog.button2Action()
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}
