import QtQuick 2.5
import QtQuick.Layouts 1.2

import com.viavi.style 1.0

//TODO: Do not lose ConfigLineInfo and ConfigLineBase, they are used in Microscope
ConfigLineBase{
    id: root

    property alias infoText: infoTextId.text

    Rectangle{
        anchors.fill: parent
        color: ViaviStyle.colors.disabledItemColor

        border.color: ViaviStyle.colors.activeColor
        border.width: ViaviStyle.layout.borderSize * 3

        Flickable{
            anchors.fill: parent
            anchors.leftMargin: ViaviStyle.layout.largeMargin
            anchors.rightMargin: ViaviStyle.layout.largeMargin

            contentWidth: infoTextId.width

            boundsBehavior: Flickable.StopAtBounds
            clip: true

            Text{
                id: infoTextId

                anchors.top: parent.top
                anchors.bottom: parent.bottom

                width: contentWidth

                verticalAlignment: Text.AlignVCenter
                horizontalAlignment: Text.AlignLeft

                color: ViaviStyle.colors.mainInfoColor
                font: ViaviStyle.layout.tableFont
            }
        }
    }
}
