import QtQuick 2.5
import QtQuick.Layouts 1.2
import QtQuick.Controls 2.0

import com.viavi.style 1.0
import com.viavi.style.components 1.0
import '..'

Item{
    id: root
    property alias text: textId.text
    signal clicked

    MouseArea{
        id: textMouseArea
        anchors.fill: parent

        onClicked: root.clicked()
    }

    Row{
        anchors.bottom: parent.bottom
        anchors.left: parent.left
        anchors.top: parent.top
        width: parent.height / 2
        spacing: ViaviStyle.layout.mediumMargin

        ColorImage{
            anchors.verticalCenter: parent.verticalCenter

            height: parent.height - 2 * ViaviStyle.layout.largeMargin

            width: height
            color: textMouseArea.pressed ? ViaviStyle.colors.selectedColor : ViaviStyle.colors.activeColor
            source: FiberStyle.images.iconSettings
        }

        Text{
            id: textId

            anchors.top: parent.top
            anchors.bottom: parent.bottom

            width: contentWidth

            font: ViaviStyle.layout.veryLargeBoldFont
            verticalAlignment: Text.AlignVCenter

            color: textMouseArea.pressed ? ViaviStyle.colors.selectedColor : ViaviStyle.colors.activeColor
        }
    }
}

