import QtQuick 2.5
import QtQuick.Controls 2.0

import com.viavi.style 1.0

Item {
    id: rootId

    property bool checked: false

    property alias text: nameLabel.text
    property alias font: nameLabel.font
    property color uncheckedColor: ViaviColor.secondaryInfoColor
    property alias textElement: nameLabel
    property alias mouseArea: mouseAreaId

    property bool centerContent: false

    width: nameLabel.width

    Text {
        id: nameLabel

        width: contentWidth
        height: contentHeight
        color: enabled || checked ? ViaviColor.activeColor : uncheckedColor

        font: rootId.checked ? ViaviStyle.layout.largeBoldFont : ViaviStyle.layout.largeFont
        verticalAlignment: Text.AlignVCenter
        anchors.horizontalCenter: centerContent ? parent.horizontalCenter : undefined
        anchors.left: centerContent ? undefined : parent.left
        anchors.verticalCenter: parent.verticalCenter
    }

    Rectangle {
        width: Math.max(rootId.width / 2, nameLabel.width)
        height: 2 * ViaviStyle.layout.borderSize
        anchors.bottom: parent.bottom
        anchors.bottomMargin: ViaviStyle.layout.smallMargin
        anchors.horizontalCenter: centerContent ? parent.horizontalCenter : undefined
        anchors.left: centerContent ? undefined : parent.left
        color: ViaviColor.activeColor
        visible: checked
    }

    PopupMouseArea {
        id: mouseAreaId
        anchors.fill: parent
        z: parent.z + 1
    }
}
