
from viavi.qrcodegen.cdm_proxy import CdmProxy
from .olts_builder import OltsBuilder, JsonLite
from .otdr_builder import OtdrBuilder


class QrCdmFactory:
    def __init__(self, cdm: CdmProxy):
        self._cdm: CdmProxy = cdm

    def create_json_lite(self) -> JsonLite:
        if self._cdm.test_type == "bidirIlOrl":
            builder = OltsBuilder(self._cdm)

        elif self._cdm.test_type == "OTDR":
            builder = OtdrBuilder(self._cdm)

        else:
            raise TypeError

        builder.produce_root_layer()
        builder.produce_sub_layers()
        builder.post_process()

        json_lite = builder.get_json_lite()

        return json_lite
