import viavi.mts.uts_spi as utsspi
import viavi.mts.uts_bdt as utsbdt
import viavi.stdhw.i2cdev  as i2cdev
from time import sleep

REG_SPI_BDT_DIVERS						= 0x08
REG_SPI_BDT_LASER						= 0x09
REG_SPI_BDT_GAIN						= 0x0C
REG_SPI_BDT_CMD_PWMTR					= 0x0E
REG_SPI_BDT_CMD_FREQ					= 0x0F
REG_SPI_BDT_XADC_TEMP_MODULE			= 0x10
REG_SPI_TEETH_NUMBER					= 0x20
REG_SPI_XOFFSET_DURATION				= 0x21
REG_SPI_WAIT_DURATION					= 0x22
REG_SPI_NOISE_DURATION					= 0x23
REG_SPI_AVERAGE_NUMBER					= 0x24
REG_SPI_RAMP_INCR						= 0x25
REG_SPI_RAMP_RESET_VAL					= 0x26
REG_SPI_COMB_NUMBER						= 0x27
REG_SPI_COMB_INCR						= 0x28
REG_SPI_CRUNCH_NUMBER					= 0x29
REG_SPI_LASER_WIDTH_ENT					= 0x2B
REG_SPI_TEETH_NUMBER_BEF_WIN			= 0x2E
REG_SPI_BDT_MISC						= 0x30
REG_SPI_LASER_WIDTH_DEC					= 0x34
REG_SPI_PRIME_RECUR						= 0x36
REG_SPI_MASQ_DURATION					= 0x37
REG_SPI_OFFSET_CONTINU					= 0x3C
REG_SPI_BDT_WAIT_ILAS_STAB				= 0x45
REG_SPI_BDT_ENABLE_IT					= 0x4A

REG_SPI_DIVERS_LED0_ON					= 0x0001
REG_SPI_DIVERS_LED1_ON					= 0x0002
REG_SPI_DIVERS_NSTANDBY					= 0x0004
REG_SPI_DIVERS_EN_PWR_ANA				= 0x0008
REG_SPI_DIVERS_VALID_SYNC				= 0x0010
REG_SPI_DIVERS_NRESET_CAN				= 0x0020
REG_SPI_DIVERS_XADC_RESET				= 0x0040
REG_SPI_DIVERS_TYPE_ADC					= 0x0080

REG_SPI_MISC_ENABLE_IRQ					= 0x00000001
REG_SPI_MISC_CLEAR_IRQ		 			= 0x00000002
REG_SPI_MISC_RESET_PLL		 			= 0x00000004
REG_SPI_MISC_ENABLE_CUMUL	 			= 0x00000008
REG_SPI_MISC_START_MEAS		 			= 0x00000010
REG_SPI_MISC_INSERT_DEBUG_PATTERN		= 0x00000020
REG_SPI_MISC_BDT_ON						= 0x00000040
REG_SPI_MISC_XOFFSET_ON		 			= 0x00000080
REG_SPI_MISC_LASER_ON		 			= 0x00000100
REG_SPI_MISC_RESET_SER_LVDS 			= 0x00000400

REG_SPI_MISC_STATUS_PLL_LOCKED 			= 0x00010000
REG_SPI_MISC_STATUS_MEAS_IN_PROGRESS 	= 0x00010000



class Piranha(object):
	def __init__(self, side, slice, spi_device = "/dev/uts_spi"):
		self.__spi = utsspi.SpiModule(side, slice, spi_device)

	def start_adp5050(self):
		cMISC_FTTX = 8
		cI2C_MOD_CS_FTTX = (1<<2)
		ADP5050_I2C_ADDRESS = 0x48
		ADP5050_SW_CFG_REG = 0x08
		ADP5050_LCH_CFG_REG = 0x07
		UTS_I2C_DEVICE_MTS24KNG = "4"

		bdt = utsbdt.UtsBdt("/dev/bdt_pws1")
		bdt.open()
		bdt.rw_register(bdt.WRITE, cMISC_FTTX, cI2C_MOD_CS_FTTX, cI2C_MOD_CS_FTTX)

		i2c = i2cdev.I2C(UTS_I2C_DEVICE_MTS24KNG)
		i2c.set_addr(ADP5050_I2C_ADDRESS)
		i2c.write([ADP5050_SW_CFG_REG, 0xF9])
		i2c.write([ADP5050_LCH_CFG_REG, 0xFF])

	def start_module(self):
		with open("/sys/platform/module_sel/pw", "w") as f:
			f.write("1")
		sleep(0.5)

		# Need to init ADP5050 by I2C
		self.start_adp5050()

		with open("/sys/platform/powersupply/enps_pw", "w") as f:
			f.write("1")
		sleep(0.5)

		with open("/sys/platform/pw_progext/s1", "bw") as progext:
			with open("/acterna/storage/share/ste_otdr_piranha_2.5.bin", "br") as fpga:
				progext.write(fpga.read())


		print("FPGA Version: %i"%self.__spi.read_mod_register8(0x7f))

		divers = 0
		divers |= REG_SPI_DIVERS_NSTANDBY
		divers |= REG_SPI_DIVERS_EN_PWR_ANA
		divers |= REG_SPI_DIVERS_VALID_SYNC
		divers |= 0x1000 # Rev_Board
		self.__spi.write_mod_register16(REG_SPI_BDT_DIVERS, divers)

		divers = self.__spi.read_mod_register16(REG_SPI_BDT_DIVERS)

		divers |= REG_SPI_DIVERS_XADC_RESET
		self.__spi.write_mod_register16(REG_SPI_BDT_DIVERS, divers)

		divers = self.__spi.read_mod_register16(REG_SPI_BDT_DIVERS)

		divers &= (~REG_SPI_DIVERS_XADC_RESET)
		self.__spi.write_mod_register16(REG_SPI_BDT_DIVERS, divers)


		misc = self.__spi.read_mod_register32(REG_SPI_BDT_MISC)

		misc |= REG_SPI_MISC_RESET_SER_LVDS

		self.__spi.write_mod_register32(REG_SPI_BDT_MISC, misc)
		misc = self.__spi.read_mod_register32(REG_SPI_BDT_MISC)
		misc &= (~REG_SPI_MISC_RESET_SER_LVDS)
		self.__spi.write_mod_register32(REG_SPI_BDT_MISC, misc)
		misc = self.__spi.read_mod_register32(REG_SPI_BDT_MISC)

		if (misc & REG_SPI_MISC_STATUS_PLL_LOCKED) == 0:
			print("ERROR PLL LOCK ERROR")
		else:
			print("PLL LOCKED OK")

		enable_it = self.__spi.read_mod_register8(REG_SPI_BDT_ENABLE_IT)
		self.__spi.write_mod_register8(REG_SPI_BDT_ENABLE_IT, 0x07)
		enable_it = self.__spi.read_mod_register8(REG_SPI_BDT_ENABLE_IT)

		#	Reg_595_Piranha [Indice_Position] = NO_LP_Piranha;
		#	Spi_Write_Reg_595 ( Position_Module, CS_595_Piranha , &Reg_595_Piranha [Indice_Position]) ;
		#	CS_595_Piranha = 0
		#	 NO_LP_Piranha  = 0x20
		# ioctl_send_and_receive(slice: 1, side: 0): TX[20 ] RX[]

		#	// Initialisation des divers DAC
		#	// pour le reglage du courant laser
		#	Init_Dac_5663 ( Position_Module, CS_DAC_LAS_Piranha, c5663_Ref_Interne, c5663_Gain_Fois_1 ) ;
		#	CS_DAC_LAS_Piranha = 0x01
		#	c5663_Ref_Interne = 0x380001
		#	c5663_Gain_Fois_1 = 0x020003
		# ioctl_send_and_receive(slice: 1, side: 0): TX[38 00 01 ] RX[]
		# ioctl_send_and_receive(slice: 1, side: 0): TX[02 00 03 ] RX[]


		# ioctl_send_and_receive(slice: 1, side: 0): TX[18 00 00 ] RX[]
		# ioctl_send_and_receive(slice: 1, side: 0): TX[38 00 01 ] RX[]
		# ioctl_send_and_receive(slice: 1, side: 0): TX[02 00 03 ] RX[]
		# ioctl_send_and_receive(slice: 1, side: 0): TX[19 00 00 ] RX[]

		temp_module = self.__spi.read_mod_register16(REG_SPI_BDT_XADC_TEMP_MODULE)

		#   //initialisation de la tension APD
		# Spi_Write_Dac_5663 ( Position_Module, CS_DAC_APD_VARICAP_Piranha, c5663_OUT_A , cValeur_Init_Dac_Pulseur_Core ) ;
		# ioctl_send_and_receive(slice: 1, side: 0): TX[18 8c e9 ] RX[]
		# ioctl_send_and_receive(slice: 1, side: 0): TX[22 ] RX[]
		# ioctl_send_and_receive(slice: 1, side: 0): TX[18 00 00 ] RX[]

		self.__spi.write_mod_register16(REG_SPI_BDT_LASER, 0x0060)


		self.__spi.write_mod_register32(REG_SPI_BDT_MISC, 0x00000002)

		cmd_pwmtr = self.__spi.read_mod_register16(REG_SPI_BDT_CMD_PWMTR)
		self.__spi.write_mod_register16(REG_SPI_BDT_CMD_PWMTR, 0x0700)

		enable_it = self.__spi.read_mod_register8(REG_SPI_BDT_ENABLE_IT)
		self.__spi.write_mod_register8(REG_SPI_BDT_ENABLE_IT, 0x03)

		cmd_pwmtr = self.__spi.read_mod_register16(REG_SPI_BDT_CMD_PWMTR)

		self.__spi.write_mod_register24(REG_SPI_BDT_WAIT_ILAS_STAB, 0x41eb0000)

		divers = self.__spi.read_mod_register16(REG_SPI_BDT_DIVERS)
		divers |= REG_SPI_DIVERS_TYPE_ADC
		self.__spi.write_mod_register16(REG_SPI_BDT_DIVERS, divers)

		#ioctl_send_and_receive(slice: 1, side: 0): TX[00 14 00 ] RX[]
		#ioctl_send_and_receive(slice: 1, side: 0): TX[00 ff 01 ] RX[]
		#ioctl_send_and_receive(slice: 1, side: 0): TX[00 15 07 ] RX[]
		#ioctl_send_and_receive(slice: 1, side: 0): TX[00 ff 01 ] RX[]

		cmd_freq = self.__spi.read_mod_register16(REG_SPI_BDT_CMD_FREQ)
		cmd_freq |= 0x0600
		self.__spi.write_mod_register16(REG_SPI_BDT_CMD_FREQ, cmd_freq)


		divers = self.__spi.read_mod_register16(REG_SPI_BDT_DIVERS)
		self.__spi.write_mod_register16(REG_SPI_BDT_DIVERS, divers)
		divers = self.__spi.read_mod_register16(REG_SPI_BDT_DIVERS)
		divers |= REG_SPI_DIVERS_LED1_ON
		self.__spi.write_mod_register16(REG_SPI_BDT_DIVERS, divers)
		divers = self.__spi.read_mod_register16(REG_SPI_BDT_DIVERS)
		divers &= (~REG_SPI_DIVERS_LED1_ON)
		self.__spi.write_mod_register16(REG_SPI_BDT_DIVERS, divers)

		temp_module = self.__spi.read_mod_register16(REG_SPI_BDT_XADC_TEMP_MODULE)


	def start_acq(self):
		cmd_freq = self.__spi.read_mod_register16(REG_SPI_BDT_CMD_FREQ)
		cmd_freq |= 0x0600
		self.__spi.write_mod_register16(REG_SPI_BDT_CMD_FREQ, cmd_freq)

		divers = self.__spi.read_mod_register16(REG_SPI_BDT_DIVERS)
		self.__spi.write_mod_register16(REG_SPI_BDT_DIVERS, divers)
		divers = self.__spi.read_mod_register16(REG_SPI_BDT_DIVERS)
		divers |= REG_SPI_DIVERS_LED1_ON
		self.__spi.write_mod_register16(REG_SPI_BDT_DIVERS, divers)

		misc = self.__spi.read_mod_register32(REG_SPI_BDT_MISC)
		self.__spi.write_mod_register32(REG_SPI_BDT_MISC, misc)

		self.__spi.write_mod_register32(REG_SPI_LASER_WIDTH_ENT, 0xA0)
		self.__spi.write_mod_register32(REG_SPI_LASER_WIDTH_DEC, 0x0)

		laser = self.__spi.read_mod_register16(REG_SPI_BDT_LASER)
		self.__spi.write_mod_register16(REG_SPI_BDT_LASER, laser)
		laser = self.__spi.read_mod_register16(REG_SPI_BDT_LASER)
		self.__spi.write_mod_register16(REG_SPI_BDT_LASER, laser)
		laser = self.__spi.read_mod_register16(REG_SPI_BDT_LASER)
		laser |= 0x1
		self.__spi.write_mod_register16(REG_SPI_BDT_LASER, laser)
		laser = self.__spi.read_mod_register16(REG_SPI_BDT_LASER)
		self.__spi.write_mod_register16(REG_SPI_BDT_LASER, laser)
		laser = self.__spi.read_mod_register16(REG_SPI_BDT_LASER)
		laser &= ~(0x40)
		laser &= ~(0x20)
		self.__spi.write_mod_register16(REG_SPI_BDT_LASER, laser)

		#ioctl_send_and_receive(slice: 1, side: 0): TX[18 83 40 ] RX[]
		#ioctl_send_and_receive(slice: 1, side: 0): TX[19 00 00 ] RX[]

		temp_module = self.__spi.read_mod_register16(REG_SPI_BDT_XADC_TEMP_MODULE)

		#ioctl_send_and_receive(slice: 1, side: 0): TX[18 90 60 ] RX[]
		#ioctl_send_and_receive(slice: 1, side: 0): TX[22 ] RX[]

		cmd_pwmtr = self.__spi.read_mod_register16(REG_SPI_BDT_CMD_PWMTR)
		self.__spi.write_mod_register16(REG_SPI_BDT_CMD_PWMTR, 0x0700)
		cmd_pwmtr = self.__spi.read_mod_register16(REG_SPI_BDT_CMD_PWMTR)

		gain = self.__spi.read_mod_register16(REG_SPI_BDT_GAIN)
		self.__spi.write_mod_register16(REG_SPI_BDT_GAIN, 0x3)

		#ioctl_send_and_receive(slice: 1, side: 0): TX[ca ] RX[]
		#ioctl_send_and_receive(slice: 1, side: 0): TX[00 0b 00 ] RX[]
		#ioctl_send_and_receive(slice: 1, side: 0): TX[00 ff 01 ] RX[]

		self.__spi.write_mod_register32(REG_SPI_TEETH_NUMBER,			0x0000f8e0)
		self.__spi.write_mod_register32(REG_SPI_XOFFSET_DURATION,		0x00000120)
		self.__spi.write_mod_register32(REG_SPI_WAIT_DURATION,			0x00000000)
		self.__spi.write_mod_register32(REG_SPI_NOISE_DURATION,		0x00000000)
		self.__spi.write_mod_register32(REG_SPI_AVERAGE_NUMBER,		0x000001e0)
		self.__spi.write_mod_register32(REG_SPI_RAMP_INCR,				0x00000003)
		self.__spi.write_mod_register32(REG_SPI_RAMP_RESET_VAL,		0x00000018)
		self.__spi.write_mod_register32(REG_SPI_COMB_NUMBER,			0x00000002)
		self.__spi.write_mod_register32(REG_SPI_COMB_INCR,				0x00000000)
		self.__spi.write_mod_register32(REG_SPI_CRUNCH_NUMBER,			0x00000000)
		self.__spi.write_mod_register32(REG_SPI_TEETH_NUMBER_BEF_WIN,	0x00000000)
		self.__spi.write_mod_register32(REG_SPI_PRIME_RECUR,			0x0000fa07)
		self.__spi.write_mod_register32(REG_SPI_MASQ_DURATION,			0x00000000)

		misc = self.__spi.read_mod_register32(REG_SPI_BDT_MISC)
		self.__spi.write_mod_register32(REG_SPI_BDT_MISC, misc)
		misc = self.__spi.read_mod_register32(REG_SPI_BDT_MISC)
		self.__spi.write_mod_register32(REG_SPI_BDT_MISC, misc)
		misc = self.__spi.read_mod_register32(REG_SPI_BDT_MISC)
		misc |= REG_SPI_MISC_RESET_PLL
		self.__spi.write_mod_register32(REG_SPI_BDT_MISC, misc)
		misc = self.__spi.read_mod_register32(REG_SPI_BDT_MISC)
		self.__spi.write_mod_register32(REG_SPI_BDT_MISC, misc)
		misc = self.__spi.read_mod_register32(REG_SPI_BDT_MISC)
		misc &= ~REG_SPI_MISC_RESET_PLL
		self.__spi.write_mod_register32(REG_SPI_BDT_MISC, misc)
		misc = self.__spi.read_mod_register32(REG_SPI_BDT_MISC)
		misc = self.__spi.read_mod_register32(REG_SPI_BDT_MISC)
		self.__spi.write_mod_register32(REG_SPI_BDT_MISC, misc)

		self.__spi.write_mod_register32(REG_SPI_OFFSET_CONTINU,		0x00000000)

		misc = self.__spi.read_mod_register32(REG_SPI_BDT_MISC)
		misc |= REG_SPI_MISC_BDT_ON
		self.__spi.write_mod_register32(REG_SPI_BDT_MISC, misc)

		misc = self.__spi.read_mod_register32(REG_SPI_BDT_MISC)
		misc &= ~REG_SPI_MISC_CLEAR_IRQ
		self.__spi.write_mod_register32(REG_SPI_BDT_MISC, misc)

		misc = self.__spi.read_mod_register32(REG_SPI_BDT_MISC)
		misc |= REG_SPI_MISC_START_MEAS
		# misc |= REG_SPI_MISC_ENABLE_IRQ   don't enable IRQ for this Piranha 2.5
		self.__spi.write_mod_register32(REG_SPI_BDT_MISC, misc)

		misc = self.__spi.read_mod_register32(REG_SPI_BDT_MISC)
		misc &= ~REG_SPI_MISC_START_MEAS
		self.__spi.write_mod_register32(REG_SPI_BDT_MISC, misc)


		#ioctl_mod_interf_access(slice: 1, side: 0): READ  address(len:1 Reg: 0x10) data(len: 2 [0x07 0x4a ])
		#ioctl_mod_interf_access(slice: 1, side: 0): READ  address(len:1 Reg: 0x10) data(len: 2 [0x07 0x4b ])
		#ioctl_mod_interf_access(slice: 1, side: 0): READ  address(len:1 Reg: 0x10) data(len: 2 [0x07 0x4d ])
		#ioctl_mod_interf_access(slice: 1, side: 0): READ  address(len:1 Reg: 0x10) data(len: 2 [0x07 0x4f ])
		#ioctl_mod_interf_access(slice: 1, side: 0): READ  address(len:1 Reg: 0x10) data(len: 2 [0x07 0x51 ])
		#ioctl_mod_interf_access(slice: 1, side: 0): READ  address(len:1 Reg: 0x10) data(len: 2 [0x07 0x52 ])
		#ioctl_mod_interf_access(slice: 1, side: 0): READ  address(len:1 Reg: 0x10) data(len: 2 [0x07 0x53 ])


		#misc = self.__spi.read_mod_register32(REG_SPI_BDT_MISC)
		#if (misc & REG_SPI_MISC_STATUS_MEAS_IN_PROGRESS) != 0:
		#	print("MEAS IN PROGRESS")


		#state = self.__spi.read_mod_register32(0x78)
		#print("FPGA State Machine: 0x%08x"%state)
		#print("\tSTATE_TEETH_DBG: 0x%08x"%((state & 0x0000000F) >> 0 ))
		#print("\tSTATE_MEAS_DBG: 0x%08x"% ((state & 0x000000F0) >> 4 ))
		#print("\tSTATE_MEAS_DBG: 0x%08x"% ((state & 0x00007000) >> 12))
		#print("\tSTATE_MEAS_DBG: 0x%08x"% ((state & 0x00070000) >> 16))
		#sleep(1)

		#state = self.__spi.read_mod_register32(0x78)
		#print("FPGA State Machine: 0x%08x"%state)


# from viavi.mts.piranha import Piranha
if __name__ == "__main__":
	module = Piranha(0, 1)
	module.start_module()
	print("MODULE STARTED")
	sleep(1)
	print("Start ACQ")
	module.start_acq()
