#!/usr/bin/python3
import json
import re
import subprocess
from subprocess import Popen, PIPE
import time
import datetime
import os
from os import path
import sys
import syslog
import logging
from collections import defaultdict
from collections import OrderedDict
from decimal import Decimal

#############################################################
def get_th_type():
    app_info_text = (((subprocess.check_output(["/sbin/getinfoversion", "Otu"])).decode("utf-8")).split(";"))
    dev_type = app_info_text[0]
    return (dev_type)

#############################################################
def send_to_otu_jrnl_log(err_text, ztp_updtime, log_info):
    #
    import systemd
    from systemd.journal import JournalHandler
    #
    #
    dlog = logging.getLogger('otu_cli')
    dlog.addHandler(JournalHandler())
    dlog.setLevel(logging.WARNING)
    if len(err_text) >  0:
       dlog.warning(err_text)
    dlog.warning(ztp_updtime)
    dlog.warning(log_info.replace("\n", " "))
    return True

#############################################################
def send_to_otu_userlog(err_text, ztp_updtime, log_info):
    if len(err_text) >  0:
        syslog.syslog(syslog.LOG_WARNING, err_text)
    syslog.syslog(syslog.LOG_WARNING, str(ztp_updtime))
    syslog.syslog(syslog.LOG_WARNING, log_info)
    return True

#############################################################
def send_od_to_otu_logging(err_text, ztp_updtime, log_info):
    log_event = json.dumps(log_info, sort_keys=False, indent=4)
    if ( "FTH-9000" in get_th_type()):
        send_to_otu_jrnl_log(err_text, ztp_updtime, log_event)
    else:
        send_to_otu_userlog(err_text, ztp_updtime, log_event)
    return True

#############################################################
def log_ztp_update_info(decl_info, upd_time):
    upd_time_info = "OTU ZTP Upgrade Info ----  " + upd_time
    if ( "FTH-9000" in get_th_type()):
        send_to_otu_jrnl_log("", upd_time_info, decl_info)
    else:
        send_to_otu_userlog("", upd_time_info, decl_info)
    return True
