#!/bin/sh

#disable globbing
set -f
RESULT=0
ROOT_ACCESS="$(fw_printenv root_access | cut -f2 -d= )"

# force smartotu login
/usr/lib/jdsu/scripts/change_smartotu_login.sh admin
RESULT=$(($RESULT+$?))

# force smartotu password
/usr/lib/jdsu/scripts/change_smartotu_password.sh password
RESULT=$(($RESULT+$?))

PLATFORM="$(tr -d '\0' < /proc/device-tree/model)"

# force root password
if [ $PLATFORM == "oth" ]; then
    usermod -p '$6$mSLmJ/5CvGelNR$a7h0fe0c125Cs33dWblWFQDLL6Wan7Uw6m/ckkaq185adtJD64pUaN8yyEZp9kz8ELV35oyiZYx/2ek/DpCR.1' root
elif [ $PLATFORM == "eotdrv2" ]; then
    usermod -p '$6$mSLmJ/5CvGelNR$IY/xRS8sO2n.Ok3RXL7rr./pWmyQyOPmVs.Ei93KgDstbxjBi.5aFsJwfM9Rt/nnpthDUAMcpc/dAjxyXFv4h/' root
elif [ $PLATFORM == "mts8000v2" ]; then
    usermod -p '$1$Koibdpp5$.pMQKYhmvP1DDWK6XAG1I/' root
else # By default, we use Otu5000 values
    echo "ERROR - PLATFORM NOT HANDLED"
    usermod -p '$6$mSLmJ/5CvGelNR$IY/xRS8sO2n.Ok3RXL7rr./pWmyQyOPmVs.Ei93KgDstbxjBi.5aFsJwfM9Rt/nnpthDUAMcpc/dAjxyXFv4h/' root
fi
RESULT=$(($RESULT+$?))

# force secuser password
if [[ "${ROOT_ACCESS}" != "true" ]] ; then
   if [ $PLATFORM == "oth" ]; then
       echo secuser:8s0e0c0 | chpasswd
   elif [ $PLATFORM == "eotdrv2" ]; then
       echo secuser:5s0e0c0 | chpasswd
   elif [ $PLATFORM == "mts8000v2" ]; then
       echo secuser:8s0e0c0 | chpasswd
   else # By default, we use Otu5000 values
       echo "ERROR - PLATFORM NOT HANDLED"
       echo secuser:5s0e0c0 | chpasswd
   fi
   RESULT=$(($RESULT+$?))
fi

echo "result: $RESULT"
exit $RESULT

