#!/bin/sh

#  Enable logging by uncommenting the next 2 lines
#OPENSSL_VALIDATION_LOG_LOCATION="/var/log"
#exec >> $OPENSSL_VALIDATION_LOG_LOCATION/ssl-cert-and-key-validation.log 2>&1

STATUS=0
sanitized_chain_loc="/tmp/sanitized_chain_certificate_file.crt"
sanitized_cert_loc="/tmp/sanitized_certificate_file.crt"
sanitized_key_loc="/tmp/sanitized_ssl_key_file"

build_key_param_block () {
    last_line_is_param=0
    buffer_open=0

    #  $1  Input key file ;  $2  Keytype either DSA or EC (ECDSA)
    #  $4 = loc_temp_file ; $3 temp_key_file
    while IFS= read line
    do
        if [ "$buffer_open" -ne 1 ]; then
           if [ "$line" ==  "-----BEGIN ""$2"" PARAMETERS-----" ]; then
               buffer_open=1
               echo "$line" >> $4
               last_line_is_param=1
           fi
        else
            if [ "$line" == "-----BEGIN ""$2"" PARAMETERS-----" ]; then
                rm -f $4 
                echo "$line" >> $4 
                last_line_is_begin=1
            elif [ "$line" == "-----END ""$2"" PARAMETERS-----" ]; then
                 if [ "$last_line_is_begin" -eq 0 ]; then
                     echo "$line" >> $4 
                     cat $4 > $3 
                 fi
                 buffer_open=0
                 rm -f $4 
            else
                last_line_is_begin=0
                echo "$line" >> $4 
            fi
        fi
    done  <"$1"
}

build_private_key_block () {
    last_line_is_begin=0
    buffer_open=0

    #  $4 = loc_temp_file ; $3 temp_key_file 
    while IFS= read line
    do
        if [ "$buffer_open" -ne 1 ]; then
           if [ "$line" ==  "-----BEGIN ""$2"" PRIVATE KEY-----" ]; then
               buffer_open=1
               echo "$line" >> $4
               last_line_is_begin=1
           fi
        else
            if [ "$line" == "-----BEGIN ""$2"" PRIVATE KEY-----" ]; then
                rm -f $4
                echo "$line" >> $4
                last_line_is_begin=1
            elif [ "$line" == "-----END ""$2"" PRIVATE KEY-----" ]; then
                 if [ "$last_line_is_begin" -eq 0 ]; then
                     echo "$line" >> $4 
                     cat $4 >> $3
                 fi
                 buffer_open=0
                 rm -f $4 
            else
                last_line_is_begin=0
                echo "$line" >> $4 
            fi
        fi
    done  <"$1"
}

build_generic_private_key_block () {
    last_line_is_begin=0
    buffer_open=0

    #  $4 = loc_temp_file ; $3 temp_key_file
    while IFS= read line
    do
        if [ "$buffer_open" -ne 1 ]; then
           if [ "$line" ==  "-----BEGIN PRIVATE KEY-----" ]; then
               buffer_open=1
               echo "$line" >> $4
               last_line_is_begin=1
           fi
        else
            if [ "$line" == "-----BEGIN PRIVATE KEY-----" ]; then
                rm -f $4
                echo "$line" >> $4
                last_line_is_begin=1
            elif [ "$line" == "-----END PRIVATE KEY-----" ]; then
                 if [ "$last_line_is_begin" -eq 0 ]; then
                     echo "$line" >> $4
                     cat $4 >> $3
                 fi
                 buffer_open=0
                 rm -f $4
            else
                last_line_is_begin=0
                echo "$line" >> $4
            fi
        fi
    done  <"$1"
}


sanitize_ssl_key () {
    private_key_file_is_valid=0
    local_temp_file="./loc-t11.txt"
    temp_key_file="./loc-t12.txt"

    if [[ "$2" == "DSA" || "$2" == "EC" ]]; then
        #  ECDSA & DSA Private key contain Paramert blocks
        #  Parameter typicall preceed the Private Key Block
        build_key_param_block "$1" "$2" "$temp_key_file" "$local_temp_file"
    fi

    # $1 input file,  $2  Key Type,
    # Extract private key blocks from the input key file  
    if [ "$2" != "PEMRSA" ]; then
        build_private_key_block "$1" "$2" "$temp_key_file" "$local_temp_file"
    else
        build_generic_private_key_block "$1" "$2" "$temp_key_file" "$local_temp_file"
    fi

    #  Check / verify that extarcted private key file is a valid OpenSSL private key
    #  The sanitized key file is emporarily held in temp_key_file;
    #  Use the temporary file to test the validity of the extracted key
    if [ "$2" == "RSA" ]; then
        SSL_RSA_KEY_CHECK=$(openssl rsa -check -noout -in $temp_key_file 2> /dev/null)
        [[ $SSL_RSA_KEY_CHECK == *"RSA key ok"* ]] && { private_key_file_is_valid=1; }

    elif [ "$2" == "PEMRSA" ]; then
        SSL_PEMRSA_KEY_CHECK=$(openssl rsa -check -noout -in $temp_key_file 2> /dev/null)
        [[ $SSL_PEMRSA_KEY_CHECK == *"RSA key ok"* ]] && { private_key_file_is_valid=1; }

    elif  [ "$2" == "DSA" ]; then
        SSL_DSA_KEY_CHECK=$(openssl dsa -noout -modulus -in $temp_key_file 2> /dev/null)
        [[ $SSL_DSA_KEY_CHECK == *"Public Key="* ]] && { private_key_file_is_valid=1; }

    else
        #  Key type must be ECDSA
        openssl pkey -pubout -in $temp_key_file -out /tmp/scratchFile
        [[ "$?" -eq 0 ]] && { private_key_file_is_valid=1; }
        [[ -f /tmp/scratchFile ]] && rm -f /tmp/scratchFile
    fi

    #  Save the sanitized keys in /tmp
    if [[ "$private_key_file_is_valid"  -eq 1 ]]; then
        SSL_KEY_STATUS=0
        [[ -f "$sanitized_key_loc" ]] && rm $sanitized_key_loc #mv $sanitized_key_loc $sanitized_key_loc.$(date +%Y%m%d%H%M%S)
        cat $temp_key_file  >> $sanitized_key_loc
        chmod 666 $sanitized_key_loc
        INPUT_KEY_FILE_SANITIZED=0
        echo "$0 $(date '+%d/%m/%Y %H:%M:%S') --   SSL private key retrieved from $1,  stored in $sanitized_key_loc"
    else
        INPUT_KEY_FILE_SANITIZED=1
        echo "$0 $(date '+%d/%m/%Y %H:%M:%S') --   SSL private key is not available from $1."
    fi

    [[ -f $temp_key_file ]] && rm -f $temp_key_file
}

sanitize_cert_input_file () {
    local_cert_block="./loc-t1.txt"
    temp_cert_file="./loc-t2.txt"
    SANITIZED_FPRINT_COUNT=0
    cert_type=""
    last_line_is_begin=0
    cert_buffer_open=0

    [[ -f $local_cert_block ]] && rm -f $local_cert_block
    [[ -f $temp_cert_file ]] && rm -f $temp_cert_file

    while IFS= read line
    do
        if [ "$cert_buffer_open" -ne 1 ]; then
           if [[ "$line" == "-----BEGIN CERTIFICATE-----"* ]]; then
               cert_buffer_open=1
               echo "-----BEGIN CERTIFICATE-----" >> $local_cert_block
               last_line_is_begin=1
           fi
        else
            if [[ "$line" == "-----BEGIN CERTIFICATE-----"* ]]; then
                rm -f $local_cert_block
                echo "-----BEGIN CERTIFICATE-----" >> $local_cert_block
                last_line_is_begin=1
            elif [[ "$line" == "-----END CERTIFICATE-----"* ]]; then
                if [ "$last_line_is_begin" -eq 0 ]; then
                    echo "-----END CERTIFICATE-----" >> $local_cert_block
                    certificate_block_valid=$(openssl x509 -text -noout -in $local_cert_block -fingerprint | grep -i fingerprint | wc -l 2> /dev/null)
                    if [ "$certificate_block_valid" -eq 0 ]; then
                        rm -f $local_cert_block
                        [[ "$2" == "chain" ]] && { [[ -f $temp_cert_file ]] && rm -f $temp_cert_file; break;}
                    else
                      cat $local_cert_block >> $temp_cert_file
                    fi
                fi
                cert_buffer_open=0
                rm -f $local_cert_block
            else
                last_line_is_begin=0
                sanitized_line=$(echo $line|tr -d '\r')
                echo "$sanitized_line" >> $local_cert_block
            fi
        fi
    done  <"$1"

    if [ "$2" == "cert" ]; then
        final_cert_loc=$sanitized_cert_loc
        cert_type="certificate(s)"
    else
        final_cert_loc=$sanitized_chain_loc
        cert_type="chain certificate"
    fi

    if [ -f $temp_cert_file ]; then
        #mv $final_cert_loc $final_cert_loc.$(date +%Y%m%d%H%M%S)
        rm $final_cert_loc
        cat $temp_cert_file  >> $final_cert_loc
        chmod 666 $final_cert_loc
        INPUT_CERT_FILE_SANITIZED=0
        echo "$0 $(date '+%d/%m/%Y %H:%M:%S') --   SSL $cert_type retrieved from $1,  stored in $final_cert_loc"
    else
        INPUT_CERT_FILE_SANITIZED=1
        echo "$0 $(date '+%d/%m/%Y %H:%M:%S') --   $1 is not a valid SSL $cert_type"
    fi

    [[ -f $local_cert_block ]] && rm -f $local_cert_block
    [[ -f $temp_cert_file ]] && rm -f $temp_cert_file

}

verify_keytype_rsa () {
  INPUT_KEY_FILE_SANITIZED=1

  NUMBER_RSA_BEGIN_MARKER=$(grep "BEGIN RSA PRIVATE KEY" $1 | wc -l 2> /dev/null)
  NUMBER_RSA_END_MARKER=$(grep "END RSA PRIVATE KEY" $1 | wc -l 2> /dev/null)

  if [[ "$NUMBER_RSA_BEGIN_MARKER" -ne 0 && "$NUMBER_RSA_END_MARKER" -ne 0 ]]; then
      sanitize_ssl_key "$1" "RSA"
      [[ "$INPUT_KEY_FILE_SANITIZED" -eq 0 ]] && { SSL_KEY_STATUS=0; STATUS=0 ; }
  fi
}

verify_keytype_pemrsa () {
  INPUT_KEY_FILE_SANITIZED=1

  NUMBER_PEMRSA_BEGIN_MARKER=$(grep "BEGIN PRIVATE KEY" $1 | wc -l 2> /dev/null)
  NUMBER_PEMRSA_END_MARKER=$(grep "END PRIVATE KEY" $1 | wc -l 2> /dev/null)

  if [[ "$NUMBER_PEMRSA_BEGIN_MARKER" -ne 0 && "$NUMBER_PEMRSA_END_MARKER" -ne 0 ]]; then
      sanitize_ssl_key "$1" "PEMRSA"
      [[ "$INPUT_KEY_FILE_SANITIZED" -eq 0 ]] && { SSL_KEY_STATUS=0; STATUS=0 ; }
  fi
}

verify_keytype_dsaparam () {
  INPUT_KEYT_FILE_SANITIZED=1

  NUMBER_DSA_BEGIN_MARKER=$(grep "BEGIN DSA PRIVATE KEY" $1 | wc -l 2> /dev/null)
  NUMBER_DSA_END_MARKER=$(grep "END DSA PRIVATE KEY" $1 | wc -l 2> /dev/null)

  if [[ "$NUMBER_DSA_BEGIN_MARKER" -ne 0 && "$NUMBER_DSA_END_MARKER" -ne 0 ]]; then
      sanitize_ssl_key "$1" "DSA"
      [[ "$INPUT_KEY_FILE_SANITIZED" -eq 0 ]] && { SSL_KEY_STATUS=0; STATUS=0 ; }
  fi
}

verify_keytype_ecparam () {
  INPUT_KEYT_FILE_SANITIZED=1

  NUMBER_ECDSA_BEGIN_MARKER=$(grep "BEGIN EC PRIVATE KEY" $1 | wc -l 2> /dev/null)
  NUMBER_ECDSA_END_MARKER=$(grep "END EC PRIVATE KEY" $1 | wc -l 2> /dev/null)

  if [[ "$NUMBER_ECDSA_BEGIN_MARKER" -ne 0 && "$NUMBER_ECDSA_END_MARKER" -ne 0 ]]; then
      sanitize_ssl_key "$1" "EC"
      [[ "$INPUT_KEY_FILE_SANITIZED" -eq 0 ]] && { SSL_KEY_STATUS=0; STATUS=0 ; }
  fi

}

verify_sslkey () {
  SSL_KEYTYPE_DSA="dsaparam"
  SSL_KEYTYPE_ECDSA="ecparam"
  SSL_KEYTYPE_RSA="rsa"
  SSL_KEYTYPE_OTHER="pemrsa"
  SSL_KEY_STATUS=1

  echo "$0 $(date '+%d/%m/%Y %H:%M:%S') --  Verifying if $1 is a valid SSL key"

  for i in $SSL_KEYTYPE_RSA $SSL_KEYTYPE_DSA $SSL_KEYTYPE_ECDSA $SSL_KEYTYPE_OTHER
  do
      [[ $SSL_KEY_STATUS -eq 1 ]] && { verify_keytype_$i "$1" "$i" 2> /dev/null; } 
  done
  
  [[ $SSL_KEY_STATUS -ne 0 ]] && { STATUS=1 ; echo "$0 $(date '+%d/%m/%Y %H:%M:%S') --   $1 is not a valid SSL key"; } 

  return $SSL_KEY_STATUS
}


verify_cert () {
  INPUT_CERT_BEGIN=0
  INPUT_CERT_END=0
  INPUT_CERT_FILE_SANITIZED=1
  STATUS=1

  echo "$0 $(date '+%d/%m/%Y %H:%M:%S') --  Verifying if $1 contains valid SSL x509 certificate(s)"
  INPUT_CERT_BEGIN=$(grep "BEGIN CERTIFICATE" $1 | wc -l 2> /dev/null)
  if [[ "$INPUT_CERT_BEGIN" -ne 0 ]]; then
      INPUT_CERT_END=$(grep "END CERTIFICATE" $1 | wc -l 2> /dev/null)
      sanitize_cert_input_file "$1" "$2" 2> /dev/null
      [[ $INPUT_CERT_FILE_SANITIZED -eq 0 ]] && { STATUS=0; }      
  else
      echo "$0 $(date '+%d/%m/%Y %H:%M:%S') --  $1 is not a valid SSL x509 certificate"
      STATUS=1
  fi

  return $STATUS
}

verify_chain () {
  INPUT_CERT_BEGIN=0
  INPUT_CERT_END=0
  INPUT_CERT_FILE_SANITIZED=1
  STATUS=1

  echo "$0 $(date '+%d/%m/%Y %H:%M:%S') --  Verifying if $1 is a valid SSL chain certificate"
  INPUT_CERT_BEGIN=$(grep "BEGIN CERTIFICATE" $1 | wc -l 2> /dev/null)
  if [[ "$INPUT_CERT_BEGIN" -ne 0 ]]; then
      INPUT_CERT_END=$(grep "END CERTIFICATE" $1 | wc -l 2> /dev/null)
      sanitize_cert_input_file "$1" "$2"  2> /dev/null
      [[ $INPUT_CERT_FILE_SANITIZED -eq 0 ]] && { STATUS=0; }
  else
      echo "$0 $(date '+%d/%m/%Y %H:%M:%S') --  $1 is not a valid SSL x509 certificate"
      STATUS=1
  fi
return $STATUS
}


verify_otu_cert_and_key () {
  OTU_CERT_TARGET=$1certs/smartotu-certificate.crt
  OTU_CHAIN_TARGET=$1certs/smartotu-certificate-chain.crt
  OTU_KEY_TARGET=$1private/smartotu-private.key

  echo "$0 $(date '+%d/%m/%Y %H:%M:%S') -- Validating the OTU certificate and key"

[[ ! -f  $OTU_CERT_TARGET || ! -f "$OTU_KEY_TARGET" ]] && { echo "$0 $(date '+%d/%m/%Y %H:%M:%S') --  One or both PKI TLS files are missing"; STATUS=1; return $STATUS; }

  PRIVATE_KEY_MODULUS_MD5=$(openssl rsa -modulus -noout -in  $OTU_KEY_TARGET  | openssl md5)
  CERTIFICATE_MODULUS_MD5=$(openssl x509 -modulus -noout -in $OTU_CERT_TARGET  | openssl md5)

  if [[ $PRIVATE_KEY_MODULUS_MD5 == $CERTIFICATE_MODULUS_MD5 ]]; then
      STATUS=0
      echo "$0 $(date '+%d/%m/%Y %H:%M:%S') --  OTU Private Key matches OTU Certificate"
  else
      STATUS=1
      echo "$0 $(date '+%d/%m/%Y %H:%M:%S') --  Mismatch between OTU Private Key and OTU Certificate"
  fi
  return $STATUS
}

is_validation_type_supported () {
  [[ "$1" == "cert" || "$1" == "chain" || "$1" == "sslkey" ]] && { return 0 ;} 
}

#  Check if the input file to this script is missing or not specified
if [ $# -eq 0 ]; then

    echo "-->"
    echo "$0 $(date '+%d/%m/%Y %H:%M:%S') -- Checking OTU certificate, key and cert chain"
    OTU_TARGET="/etc/pki/tls/"
    verify_otu_cert_and_key $OTU_TARGET
    exit $STATUS

elif [ $# -eq 2 ]; then

    [ ! -f "$1" ] &&  { echo "$0 $(date '+%d/%m/%Y %H:%M:%S') -- $1 File Not Found"  ; exit 1 ;} 

    echo "-->"
    typecheck=$2
    typecheck=${typecheck,,}

    is_validation_type_supported $typecheck
    if [ $? -ne 0 ]; then 
        echo "$0 $(date '+%d/%m/%Y %H:%M:%S') -- Requested verification type \"$2\" is not available for input file $1 "
        echo ""
        exit 1
    fi

    verify_$typecheck $1 $typecheck
    echo ""
    exit $STATUS
else

    echo "-->"
    echo "$0 $(date '+%d/%m/%Y %H:%M:%S') -- Invalid number of arguments for $1"
    exit 1

fi

