#!/bin/bash
#set -x

DEVICE="/dev/"`ls -al /dev/Usb_Flash_Device | cut -d'>' -f2 | sed -e 's/ //'`
DEVICE_PART=$DEVICE"1"
DEVICE_PART_LABEL="JDSUFORMAT"
STICK_USER_DIRECTORY="/user/usbflash"

PGNAME=`basename $0`
####################################################################
function Vfat_Format()
{
	DEV_PART=$1
	LABEL=$2

	CMD="mkfs.vfat -F 32 -n $LABEL $DEV_PART"
	logger -t mkfs.vat "$CMD"

	$CMD
	return $?
}

####################################################################
function LOG()
{
	echo $*
	logger -t $PGNAME $*
}
####################################################################
function Format()
{

	if [ ! -b $DEVICE ]
	then
		LOG "No device "$DEVICE
		return 1
	fi

	sync
	dd if=/dev/zero of=$DEVICE bs=100k count=10
	sync
sleep 1
	fdisk $DEVICE << EOF
n
p



t
b
wq
EOF
        sync
	if [ $? != 0 ]
	then
		LOG "Cannot create partitions table"
		return 1
	fi

	Vfat_Format $DEVICE_PART $DEVICE_PART_LABEL
	return 0
}
####################################################################
function Not_Used()
{
	echo | sfdisk $DEVICE 2>&1 | grep BLKRRPART
	if [ $? == 0 ]
	then
		LOG $DEVICE" is in use"
		return 1
	fi

	LOG $DEVICE" is not used"
	return 0
}
####################################################################

/etc/init.d/udev stop
Not_Used
rtn=$?
if [ $rtn == 0 ]
then
	sleep 1
	Format
	rtn=$?
fi
/etc/init.d/udev start

if [ ! -e /$STICK_USER_DIRECTORY ]
then
   mkdir -p /$STICK_USER_DIRECTORY
fi
mount -t auto $DEVICE_PART /$STICK_USER_DIRECTORY
exit $rtn

