#!/bin/bash
# ORE OTU 8KV2 19/12/11
# usage: get-snapshot {<mode [usb/sys/ftp/hd(default)]> {<ftp-ip-addr> {<ftp-username> {<ftp-password>}}}}


RC=0

[[ -f /etc/profile.d/platform.conf.sh ]]   && source /etc/profile.d/platform.conf.sh
[[ -f /etc/profile.d/40_otu_platform.sh ]]   && source /etc/profile.d/40_otu_platform.sh

PLATFORM="$(tr -d '\0' < /proc/device-tree/model)"

# test base type
if [ `hexdump -e '1/4 "%d\n"'  /proc/device-tree/board/info-otu-board` == 0 ]
then
    OTU=no
else
    OTU=yes
fi

MODE=$1
/usr/bin/test -z $MODE && MODE=hd

FTP_IPADDR=$2
/usr/bin/test -z $FTP_IPADDR && FTP_IPADDR=10.10.52.31

FTP_USER=$3
/usr/bin/test -z $FTP_USER && FTP_USER=upgrader

FTP_PASSWORD=$4
/usr/bin/test -z $FTP_PASSWORD && FTP_PASSWORD=password

ADD_LOG_FILE="/var/log/get-snapshot.log"

#from etc/init.d/otu_rfs_sync.sh
WATCHED_FILES_LIST="
/etc/shadow
/etc/passwd
/etc/password_removed
/etc/shadow_removed
/etc/hostname
/etc/aliases
/etc/group
/root/.ssh/authorized_keys
/etc/sysconfig/iptables
/etc/sysconfig/ip6tables
/acterna/storage/share/ssu.conf
/acterna/storage/otu/calibration/otu.cal
/acterna/storage/otu/communication/media.cfg
/acterna/storage/otu/communication/webservice.cfg
/acterna/storage/otu/communication/port.cfg
/acterna/storage/otu/communication/superv.cfg
/acterna/storage/otu/communication/snmp.cfg
/acterna/storage/otu/communication/modem.cfg
/acterna/storage/otu/communication/sms.cfg
/acterna/storage/otu/communication/tsc.cfg
/acterna/storage/otu/communication/alerte.cfg
/acterna/storage/otu/communication/interface.cfg
/acterna/storage/otu/communication/topaz.cfg
/acterna/storage/isu/config/cotu_license.xml
/etc/pki/tls/private/smartotu-private.key
/etc/pki/tls/certs/smartotu-certificate.crt
/etc/pki/tls/certs/smartotu-certificate-chain.crt"


# Create a get-snapshot log with various tidbits of information...
echo "--      Base `hostname` (`/sbin/getserialnb`) snapshot (`date`)      --" >  $ADD_LOG_FILE
exec >> $ADD_LOG_FILE 2>&1

echo " "
echo "CMD : ifconfig"
/sbin/ifconfig
echo "----------------"
echo "CMD : netstat -natp"
/bin/netstat -natp
echo "----------------"
echo "CMD : runlevel `/sbin/runlevel`"
echo "----------------"
echo "CMD : ps -axfl"
ps -axfl
echo "----------------"
echo "CMD : set"
set
echo "----------------"
echo "CMD : fw_printenv"
fw_printenv
echo "----------------"
echo "CMD : df"
/bin/df
echo "----------------"
echo "CMD : mount"
mount
echo "----------------"
echo "CMD : uptime"
/usr/bin/uptime
if [ $OTU = "yes" ]
then
	echo "----------------"
	echo "CMD : ls /otu/alarm/ |wc -w"
	ls /otu/alarm/ |wc -w

	echo "----------------"
	echo "CMD : memory info"
	DATE=`date`
	MEM_FREE=`cat /proc/meminfo |grep "MemFree:"|awk '{ print $2 }'`
	MEM_CACHED=`cat /proc/meminfo |grep "^Cached:"|awk '{ print $2 }'`
	MEM_X=`ps -axfl|grep "Xvfb :0"|grep -v "grep"|awk '{ print $7 }'`
	echo $DATE" - MEM:"$MEM_FREE" "$MEM_CACHED" - X:"$MEM_X

	echo "----------------"
	echo "CMD : CRC check"
	#/sbin/create_crcfile.sh /otu/crcfile.cur
	#/sbin/compare_crcfile.sh /etc/acterna/crcfile /otu/crcfile.cur /otu/cmpfile
	#cat /otu/cmpfile | grep -v 8.4
	echo "Not yet implemented !"

	echo "----------------"
	echo "CMD : cat /sys/platform/uts_scan/scan"
	cat /sys/platform/uts_scan/scan

	echo "----------------"
	echo "CMD : getinfoversion Otu"
	/sbin/getinfoversion Otu
	echo " "
	echo "CMD : getinfoversion -r Otu"
	/sbin/getinfoversion -r Otu
	echo ""

	echo "---------------- options"
	echo "CMD : fw_printenv -n Enhanced_Security"
	fw_printenv -n Enhanced_Security
	echo "CMD : fw_printenv -n rescue_mode"
	fw_printenv -n rescue_mode
	echo "CMD : fw_printenv -n use_both_fs"
	fw_printenv -n use_both_fs
	echo ""

	echo "---------------- uptime loadavg"
	# uptime Uptimes.Up1Min Uptimes.Up5Min Uptimes.Up15Min
	echo "CMD : cat /proc/loadavg"
	cat /proc/loadavg
	echo ""

    echo "---------------- fds"
    # all open fds
	echo "CMD : lsof | wc -l"
	lsof | wc -l
	# fds in Kernel
	echo "CMD : sysctl fs.file-nr"
	sysctl fs.file-nr
	echo ""

	function OTH_temperature
	{
		sensors
	}

	function legacy_temperature
	{
		# Cpu_Temperature
		echo "CMD : cat /sys/class/hwmon/hwmon0/temp1_input"
		cat /sys/class/hwmon/hwmon0/temp1_input
		# Board_Temperature
		echo "CMD : cat /sys/class/hwmon/hwmon1/temp1_input"
		cat /sys/class/hwmon/hwmon1/temp1_input
		# EOTDR_Temperature
		echo "CMD : cat /sys/platform/adc_temp_ana/value"
		cat /sys/platform/adc_temp_ana/value
	}

	echo "---------------- temp"
	if [[ $PLATFORM == "oth" ]]; then
		OTH_temperature
	else
		legacy_temperature
	fi
	echo ""

	echo "---------------- local mode?"
	if [ -f "/var/run/dhcpd_otu_local.pid" ]
    then
        echo "/var/run/dhcpd_otu_local.pid found --> Local mode"
    else
        echo "/var/run/dhcpd_otu_local.pid not found --> Not in local mode"
    fi
    echo ""


   	function OTH_leds
   	{
		local P="/sys/class/leds"
		for i in unit optic server test status ; do
			echo "CMD : cat $P/$i:green/brightness"
			cat $P/$i:green/brightness
			echo "CMD : cat $P/$i:red/brightness"
			cat $P/$i:red/brightness
		done
   	}

	function legacy_leds
	{
		for i in "/sys/class/leds/led_"*
		do
			echo "CMD : cat $i/brightness"
			cat $i/brightness
		done
	}

    echo "---------------- LEDs"
   	if [[ $PLATFORM == "oth" ]]; then
		OTH_leds
	else
		legacy_leds
    echo ""
	fi
    echo ""

    echo "---------------- board"
	echo "CMD : hexdump  /proc/device-tree/board/info-otu-board"
	hexdump  /proc/device-tree/board/info-otu-board
	echo "CMD : hexdump  /proc/device-tree/board/board-version"
	hexdump  /proc/device-tree/board/board-version
	echo "CMD : hexdump  /proc/device-tree/board/backplane-id"
	hexdump  /proc/device-tree/board/backplane-id
	echo ""

    echo "---------------- platform"
    function test_value
    {
            echo "CMD : cat $1"
        if [[ -f "$1" ]]; then
            cat $1
        else
            echo "NO $1"
        fi
    }
	# other stuff
	test_value /sys/platform/board_fpga/reg_version
	test_value /sys/platform/board_fpga/reg_date
    test_value /sys/platform/board_fpga/hw_ver
	test_value /sys/platform/hwrev/value
	test_value /sys/platform/pwr_front_left/value
	test_value /sys/platform/pwr_front_right/value
	test_value /sys/platform/pwr_rear_left/value
	test_value /sys/platform/pwr_rear_right/value
	test_value /sys/platform/pwr_otu_valid/value
	test_value /sys/platform/pwr_usb_valid/value
	echo ""

    echo "---------------- eth0 stats"
    for i in "/sys/class/net/eth0/statistics/"*
    do
    echo "CMD : cat $i"
    cat $i
    done
    echo ""

    echo "------------- rpm list"
	rpm -qa | sort
	echo ""

	echo "------------- top"
    top -b -n 1 -w 512
	echo ""

   	if [[ $PLATFORM == "oth" ]]; then
	echo "------------- list /dev/disk/by-label/JD*"
	ls -al /dev/disk/by-label/JD*
   	else
	echo "------------- list /dev/JD*"
	ls -al /dev/JD*
	fi
	echo ""

    echo "------------- CMD: fdisk -l /dev/mmcblk0"
	fdisk -l /dev/mmcblk0
	echo ""

    echo "------------- CMD: /usr/lib/jdsu/scripts/Internal_Memory_Mngt.sh CHECKHD"
	/usr/lib/jdsu/scripts/Internal_Memory_Mngt.sh CHECKHD
	echo ""


	echo "------------- CMD: cat /etc/release/backup/*"
	cat /etc/release/backup/*
	echo ""



    echo "---------------- Check File Synch"
	for i in $WATCHED_FILES_LIST
    do
        if [ ! -f /mnt/fs/unused_part$i ]
        then
            echo "File /mnt/fs/unused_part$i does not exist"
        else
            echo "CMD: diff -u $i /mnt/fs/unused_part$i"
            diff -u $i /mnt/fs/unused_part$i
        fi
    done
    echo ""
fi

echo "Creating ${CFG_MKT_PLATFORM_NAME} snapshot for unit #`/sbin/getserialnb`"
TAR_FILE=get-snapshot.`/sbin/getserialnb`.$(date +%Y%m%d%H%M).tar.gz

if [[ $PLATFORM == "oth" ]]; then
    # arrêt du logrotate avant génération du dump des journaux
    systemctl stop logrotate.timer
    systemctl stop logrotate.service
    otu_log "${CFG_MKT_PLATFORM_NAME}: get "$TAR_FILE" ("$MODE")"
    journalctl > /var/log/user.log
else
    logger "${CFG_MKT_PLATFORM_NAME}: get "$TAR_FILE" ("$MODE")"
fi

if [ $MODE != "sys" ]; then
   LOGINRAM=`df | grep ram0 | wc -l`
else
   LOGINRAM=1
fi

if [ $LOGINRAM = 1 ]; then
   tar -hzcvf /tmp/$TAR_FILE /etc/acterna/*.ver /etc/release/version/*.ver /acterna/storage/isu/*.cfg /var/log /acterna/storage/share 2>&1 | grep -v "Removing leading"
   if [ `/bin/df | grep harddisk |wc -l` != 0 ]; then
      DF=`/bin/df | grep harddisk | awk '{ print $5 }' | cut -f1 -d '%'`
   else
      DF=0
   fi

   if [ ! -f /tmp/$TAR_FILE ]; then
     	RC=1
   fi

else

   if [ $OTU = "yes" ]; then
      tar -hzcvf /user/harddisk/$TAR_FILE --exclude='*.xsvf' --exclude='*.jbc' --exclude='*.bin' --exclude='*.png' --exclude='*.xpm' --exclude="/var/log/journal" /etc/acterna/*.ver /etc/release/current.xml /etc/release/version/*.ver /acterna/storage/isu/*.cfg /var/log /acterna/storage/share /otu/config/measure /otu/log /otu/autotest /otu/alarm/backup /otu/alarm/backuptrace /acterna/storage/otu /mnt/fs/unused_part//etc/release/version/*.ver /mnt/fs/unused_part/etc/release/current.xml /mnt/fs/unused_part/acterna/storage/isu/*.cfg /mnt/fs/unused_part/acterna/storage/share  /mnt/fs/unused_part/acterna/storage/otu 2>&1 | grep -v "Removing leading"
   else
      tar -hzcvf /user/harddisk/$TAR_FILE /etc/acterna/*.ver /etc/release/current.xml /etc/release/version/*.ver /acterna/storage/isu/*.cfg /var/log /acterna/storage/share 2>&1 | grep -v "Removing leading"
   fi

   if [ ! -f /user/harddisk/$TAR_FILE ]; then
    	RC=1
   fi

   DF=`/bin/df | grep -w "/tmp" | awk '{ print $5 }' | cut -f1 -d '%'`
fi

if [[ $PLATFORM == "oth" ]]; then
    rm /var/log/user.log
    # démarrage de logrotate après génération du tarball
    systemctl start logrotate.service
    systemctl start logrotate.timer
fi

if [ "$DF" = "100" ]; then
   echo "no space left"
   RC=1
else
   if [ "$MODE" = "usb" ]; then
      if [ $LOGINRAM = 1 ]; then
         echo "Copy snapshot to usb flash memory"
         cp /tmp/$TAR_FILE /user/usbflash/.
		 let RC=RC+$?
      else
         echo "Copy snapshot to usb flash memory"
         cp /user/harddisk/$TAR_FILE /user/usbflash/.
		 let RC=RC+$?
      fi
   fi

   if [ $MODE = "hd" ]; then
      if [ $LOGINRAM = 1 ]
      then
         echo "Copy snapshot to harddisk"
         cp /tmp/$TAR_FILE /user/harddisk/.
		 let RC=RC+$?
      fi
   fi

   if [ $MODE = "ftp" ]; then
      echo "Uploading snapshot to IP address '$FTP_IPADDR' with username '$FTP_USER' and password '$FTP_PASSWORD'"
      echo "with username '$FTP_USER' and password '$FTP_PASSWORD'"
      echo user                          > /tmp/ftpLogin
      echo $FTP_USER $FTP_PASSWORD      >> /tmp/ftpLogin
      echo binary                       >> /tmp/ftpLogin
      if [ $LOGINRAM = 1 ]
      then
         echo put /tmp/$TAR_FILE $TAR_FILE >> /tmp/ftpLogin
      else
         echo put /user/harddisk/$TAR_FILE $TAR_FILE >> /tmp/ftpLogin
      fi
      ftp -n -v $FTP_IPADDR < /tmp/ftpLogin
      let RC=RC+$?
   fi

   # Cleanup temporary files
   rm -f /tmp/ftpLogin

   if [ $MODE != "sys" ]; then
      rm -rf /tmp/$TAR_FILE
   else
      mv /tmp/$TAR_FILE /tmp/snapshot
   fi
   rm -f $ADD_LOG_FILE
fi

# return 0 if success, positive value otherwise
exit $RC
