import os
from lxml import etree
from viavi.mts import getMachineName

def filter(release):
    # Get machine
    machine = getMachineName()

    # Get target File System version
    def concat_version(major, minor):
        return major * 100 + minor

    major = int(release.xpath("content/item[@name='File System']/@version")[0].split(".")[0].replace("V",""))
    minor = int(release.xpath("content/item[@name='File System']/@version")[0].split(".")[1])
    mts_version = concat_version(major, minor)

    # Get HW revision
    with open("/proc/device-tree/board/board-version",'rb') as raw:
        hw = raw.read()
    hw_revision = hw[0]

    # Prevent Downgrade before Verveine for 70310NB10 and 70310TB10
    if machine == 'mts4000ng' and hw_revision > 4 and mts_version < concat_version(21, 10):
        print("Downgrade to version File System %i.%i < 21.10 Forbiden for NB10 or TB10"%(major,minor))
        return False

    return True
