import QtQuick 2.3
import com.viavi.style 1.0

Rectangle {
    width: 80
    height: parent != undefined ? parent.height : 0

    color: isSelected ? ViaviStyle.colors.viaviPurple : "transparent"
    visible: ( typeof isVisible === "undefined" ) ? true : isVisible
    opacity: isEnabled ? 1 : 0.4
    
    radius: isSelected ? 4 : 0

    Text {
        text: name
        color: isSelected ? ViaviStyle.colors.white : ViaviStyle.colors.darkGray
        font.pixelSize: isSelected ? 20 : (isEnabled ? 18 : 16 )
        font.italic: !isEnabled
        font.bold: isSelected
        clip: true
        anchors.fill: parent
        wrapMode: Text.WordWrap
        verticalAlignment: Text.AlignVCenter
        horizontalAlignment: Text.AlignHCenter
    }

    MouseArea {
        anchors.fill: parent
        enabled: isEnabled
        onClicked: {
           selectValueChanged( index );
        }
    }
}
