import QtQuick 2.3

import com.viavi.style 1.0

Rectangle {
   id: container

   width: 600
   height: 70

   color: ViaviStyle.colors.lightGray2
   
   property int nbButtons: standardButton.visible + realTimeButton.visible
    
   property int buttonWidth: container.height * 1.5
   property int buttonHeight: container.height
   
   property int textSize: 18
   property color original_color : ViaviStyle.colors.secondaryInfoColor
   
   property bool isEnabled: wizardSetupData_res_isLaserAvailable.value
   
   Rectangle {
      anchors.top: parent.top
      anchors.bottom: parent.bottom
      anchors.left: parent.left
      anchors.right: rowButtons.left
      anchors.rightMargin: 2
    
      color: ViaviStyle.colors.secondaryInfoColor
    
      Text {
         id: configTxt
         
         anchors.fill: parent
         color: ViaviStyle.colors.lightGray2
         
         anchors.left: parent.left
         anchors.leftMargin: 10
         anchors.verticalCenter: parent.verticalCenter
         
         text: wizardWindowManager_res_txtConfigSetupWindow.value
         verticalAlignment: Text.AlignVCenter
         horizontalAlignment: Text.AlignLeft
         font.pixelSize: 20
         font.italic: true
         wrapMode: Text.Wrap
         
         clip: true
       }
    }
    
   Row {
      id: rowButtons
      
      anchors.top: parent.top
      anchors.bottom: parent.bottom
      anchors.right: parent.right
      
      layoutDirection: Qt.RightToLeft
      
      spacing: 2
      
      Rectangle {
         id: resultButton
         width: buttonWidth
         height: buttonHeight
         
         color: ViaviStyle.colors.activeColor
         
         enabled: !wizardWindowManager_res_canGoBackOnClick.value
         opacity: enabled ? ( mouseAreaResultButton.pressed ? 0.8 : 1 ) : 0.4
         visible: true
         
         Text {
             id: textResults
             color: ViaviStyle.colors.white
             
             anchors.top: parent.top
             anchors.topMargin: 2
             anchors.horizontalCenter: parent.horizontalCenter
             
             text: wizardWindowManager_res_txtResults.value
             
             horizontalAlignment: Text.AlignHCenter
             
             font.pixelSize: textSize
             font.bold: mouseAreaResultButton.pressed
             wrapMode: Text.Wrap             
         }
                
         Image {
            source: "/acterna/storage/look-and-feel/generic/icon_popup_view_results.png"
         
            anchors.bottom: parent.bottom
            anchors.bottomMargin: 2
            anchors.top: textResults.bottom
            anchors.topMargin: 2
            anchors.horizontalCenter: parent.horizontalCenter
            
            fillMode: Image.PreserveAspectFit
            smooth: true
         }
         
         MouseArea {
            id: mouseAreaResultButton
            
             anchors.fill: parent
             onClicked: {
               wizardSetupData_act_applyData.invoke()
               wizardWindowManager_act_closeSetupWindows.invokeWithStringArg("true") //Regular exit when pressed
             }           
         }
       }
      
      Rectangle {
         id: realTimeButton
         width: buttonWidth
         height: buttonHeight
         
         color: ViaviStyle.colors.activeColor
         
         enabled: isEnabled
         opacity: isEnabled ? ( mouseAreaRealTimeButton.pressed ? 0.8 : 1 ) : 0.4
         visible: wizardSetupData_res_isRealTimeVisible.value
          
         Text {
             color: ViaviStyle.colors.white
             anchors.fill: parent
             text: wizardWindowManager_res_txtRealTime.value
             horizontalAlignment: Text.AlignHCenter
             verticalAlignment:  Text.AlignVCenter
             font.pixelSize: textSize
             font.bold: mouseAreaRealTimeButton.pressed
            wrapMode: Text.Wrap              
         }
         
         MouseArea {
            id: mouseAreaRealTimeButton
            
             anchors.fill: parent
             onClicked: {
               wizardSetupData_act_applyData.invoke()
               wizardWindowManager_act_startRealTimeAcquisition.invoke()
             }
         }
      }
		
	   Rectangle {
			id: standardButton
			width: buttonWidth
			height: buttonHeight
			
			color: ViaviStyle.colors.activeColor
			
			enabled: isEnabled
			opacity: isEnabled ? ( mouseAreaStandardButton.pressed ? 0.8 : 1 ) : 0.4
            visible: wizardSetupData_res_isStartAcqVisible.value
				    
			Text {
			    color: ViaviStyle.colors.white
			    anchors.fill: parent
			    text: wizardWindowManager_res_txtStandard.value
			    horizontalAlignment: Text.AlignHCenter
			    verticalAlignment:  Text.AlignVCenter
			    font.pixelSize: textSize
			    font.bold: mouseAreaStandardButton.pressed
			    wrapMode: Text.Wrap	            
			}
			
			MouseArea {
				id: mouseAreaStandardButton
				
			    anchors.fill: parent
			    onClicked: {
					wizardSetupData_act_applyData.invoke()
                    wizardWindowManager_act_startAcquisition.invoke()
			    }           
			}
	    }
       
       Rectangle {
         id: configButton
         width: buttonWidth
         height: buttonHeight
         
         color: ViaviStyle.colors.activeColor
         
         enabled: true
         opacity: mouseAreaConfigButton.pressed ? 0.8 : 1
         visible: wizardWindowManager_res_canGoBack.value
         
         Text {
             id: textConfigs
             color: ViaviStyle.colors.white
             
             anchors.top: parent.top
             anchors.topMargin: 2
             anchors.horizontalCenter: parent.horizontalCenter
             
             text: wizardWindowManager_res_txtConfigs.value
             
             horizontalAlignment: Text.AlignHCenter
             
             font.pixelSize: textSize
             font.bold: mouseAreaConfigButton.pressed
             wrapMode: Text.Wrap             
         }
                
         Image {
            source: "/acterna/storage/look-and-feel/generic/icon_popup_view_file.png"
         
            anchors.bottom: parent.bottom
            anchors.bottomMargin: 2
            anchors.top: textConfigs.bottom
            anchors.topMargin: 2
            anchors.horizontalCenter: parent.horizontalCenter
            
            fillMode: Image.PreserveAspectFit
            smooth: true
         }
         
         MouseArea {
            id: mouseAreaConfigButton
            
             anchors.fill: parent
             onClicked: {
               wizardSetupData_act_applyData.invoke()
               wizardWindowManager_act_closeSetupWindows.invokeWithStringArg("false")
             }           
         }
       }
	    
	    /*
	    Wizard_Exit_Button {
         id: exitButton
         width: buttonWidth
         height: buttonHeight
         
         enableLongPress: wizardWindowManager_res_canGoBack.value
         enableBackOnClick: wizardWindowManager_res_canGoBackOnClick.value
         
         color: container.original_color
         textDef: wizardWindowManager_res_txtExit.value
         textsize: textSize
         durationLongTimer: 1500
         
         onPressedButton: {
               wizardSetupData_act_applyData.invoke()
               wizardWindowManager_act_closeSetupWindows.invokeWithStringArg("true") //Regular exit when pressed
               }  
         
         onLongPressedButton: {
               wizardSetupData_act_applyData.invoke()
               wizardWindowManager_act_closeSetupWindows.invokeWithStringArg("false") // back to the previous page
               }    
      }	  */
    }	  
}
