import QtQuick 2.3
import libfo 1.0

import com.viavi.style 1.0

Rectangle {
   id: container
   
   width: 600
   height: 70
   
   color: ViaviStyle.colors.lightGray2
    
   property bool validationIsPossible: false
    
   property int buttonWidth: container.height * 1.5
   property int buttonHeight: container.height
   
   property int textSize: 18
   
   Rectangle {
      anchors.top: parent.top
      anchors.bottom: parent.bottom
      anchors.left: parent.left
      anchors.right: rowButtons.left
      anchors.rightMargin: 2
    
      color: ViaviStyle.colors.secondaryInfoColor
    
      Text {
         id: configTxt
         
         anchors.fill: parent
         color: ViaviStyle.colors.lightGray2
         
         anchors.left: parent.left
         anchors.leftMargin: 10
         anchors.verticalCenter: parent.verticalCenter
         
         text: wizardRecordingInformation_res_saveInDirLabel.value + " " + wizardRecordingInformation_res_dirName.value
         verticalAlignment: Text.AlignVCenter
         horizontalAlignment: Text.AlignLeft
         font.pixelSize: 20
         font.italic: true
         wrapMode: Text.Wrap
         
         clip: true
       }
    }
       
    Row {
      id: rowButtons
      
      anchors.top: parent.top
      anchors.bottom: parent.bottom
      anchors.right: parent.right
      
      layoutDirection: Qt.RightToLeft
      
      spacing: 2
      
      Rectangle {
         id: resultButton
         width: buttonWidth
         height: buttonHeight
         
         color: ViaviStyle.colors.activeColor
         
         enabled: true
         opacity: enabled ? ( mouseAreaResultButton.pressed ? 0.8 : 1 ) : 0.4
         visible: true
         
         Text {
             id: textResults
             color: ViaviStyle.colors.white
             
             anchors.top: parent.top
             anchors.topMargin: 2
             anchors.horizontalCenter: parent.horizontalCenter
             
             text: wizardWindowManager_res_txtResults.value
             
             horizontalAlignment: Text.AlignHCenter
             
             font.pixelSize: textSize
             font.bold: mouseAreaResultButton.pressed
             wrapMode: Text.Wrap             
         }
                
         Image {
            source: "/acterna/storage/look-and-feel/generic/icon_popup_view_results.png"
         
            anchors.bottom: parent.bottom
            anchors.bottomMargin: 2
            anchors.top: textResults.bottom
            anchors.topMargin: 2
            anchors.horizontalCenter: parent.horizontalCenter
            
            fillMode: Image.PreserveAspectFit
            smooth: true
         }
         
         MouseArea {
            id: mouseAreaResultButton
            
             anchors.fill: parent
             onClicked: {
                wizardWindowManager_act_closeRecordingInformationWindows.invoke()
             }           
         }
       }
	    
	    Rectangle {
	        id: filePdfButton
	        width: buttonWidth
	        height: buttonHeight
	        color: ViaviStyle.colors.activeColor
	
	        anchors.verticalCenter: parent.verticalCenter
	        
            enabled: validationIsPossible
            opacity: validationIsPossible ? ( mouseAreaFilePdf.pressed ? 0.8 : 1 ) : 0.4
	        
            visible: wizardRecordingInformation_res_filePdfVisible.value
	        
	        Text {
	            color: ViaviStyle.colors.white
	            anchors.fill: parent
	            text: wizardWindowManager_res_txtFilePdf.value
	            horizontalAlignment: Text.AlignHCenter
	            verticalAlignment:  Text.AlignVCenter
	            font.pixelSize: textSize
	            font.bold: mouseAreaFilePdf.pressed
	        }
	
	        MouseArea {
	        	id: mouseAreaFilePdf
	        
	            anchors.fill: parent
	            onClicked: {
	            if ( validationIsPossible != false )
	               {
                   wizardRecordingInformation_cfg_saveMode.value = wizardRecordingInformation_cfg_saveMode.enums.ermRecordingFilePdf
                   wizardRecordingInformation_act_saveAquisition.invoke()
                   wizardWindowManager_act_closeRecordingInformationWindows.invoke()
	               }
	            }
	        }
	    }
	    
	    Rectangle {
	        id: fileTxtButton
	        width: buttonWidth
	        height: buttonHeight
	        color: ViaviStyle.colors.activeColor
	
	        anchors.verticalCenter: parent.verticalCenter
	        
	        enabled: validationIsPossible
	        opacity: validationIsPossible ? ( mouseAreaFileTxt.pressed ? 0.8 : 1 ) : 0.4
	        
            visible: wizardRecordingInformation_res_fileTxtVisible.value
	        
	        Text {
	            color: ViaviStyle.colors.white
	            anchors.fill: parent
	            text: wizardWindowManager_res_txtFileTxt.value
	            horizontalAlignment: Text.AlignHCenter
	            verticalAlignment:  Text.AlignVCenter
	            font.pixelSize: textSize
	            font.bold: mouseAreaFileTxt.pressed
	        }
	
	        MouseArea {
	        	id: mouseAreaFileTxt
	        	
	            anchors.fill: parent
	            onClicked: {
	            if ( validationIsPossible != false )
	               {
                    wizardRecordingInformation_cfg_saveMode.value = wizardRecordingInformation_cfg_saveMode.enums.ermRecordingFileTxt
                    wizardRecordingInformation_act_saveAquisition.invoke()
                    wizardWindowManager_act_closeRecordingInformationWindows.invoke()
	               }
	            }
	        }
	    }
	    
       Rectangle {
           id: fileOnlyButton
           width: buttonWidth
           height: buttonHeight
           color: ViaviStyle.colors.activeColor
           anchors.verticalCenter: parent.verticalCenter
           
           enabled: validationIsPossible
           opacity: validationIsPossible ? ( mouseAreaFileOnly.pressed ? 0.8 : 1 ) : 0.4
           
           visible: wizardRecordingInformation_res_fileOnlyVisible.value
           
           Text {
               color: ViaviStyle.colors.white
               anchors.fill: parent
               text: wizardWindowManager_res_txtFileOnly.value
               horizontalAlignment: Text.AlignHCenter
               verticalAlignment:  Text.AlignVCenter
               font.pixelSize: textSize
               font.bold: mouseAreaFileOnly.pressed
           }
   
           MouseArea {
            id: mouseAreaFileOnly
            
               anchors.fill: parent
               
               onClicked: {
               if ( validationIsPossible != false )
                  {
                   wizardRecordingInformation_cfg_saveMode.value = wizardRecordingInformation_cfg_saveMode.enums.ermRecordingFileOnly
                   wizardRecordingInformation_act_saveAquisition.invoke()
                   wizardWindowManager_act_closeRecordingInformationWindows.invoke()
                  }
               }
           }
       }

/*
       Rectangle {
           id: exitButton
           width: buttonWidth
           height: buttonHeight
           color: ViaviStyle.colors.secondaryInfoColor
           anchors.verticalCenter: parent.verticalCenter
           anchors.leftMargin: 20
           
           opacity: mouseAreaExit.pressed ? 0.8 : 1
   
           Text {
               color: ViaviStyle.colors.white
               anchors.fill: parent
               text: wizardWindowManager_res_txtExitRecording.value
               horizontalAlignment: Text.AlignHCenter
               verticalAlignment:  Text.AlignVCenter
               font.pixelSize: textSize
               font.bold: mouseAreaExit.pressed
           }
   
           MouseArea {
            id: mouseAreaExit
            
               anchors.fill: parent
               onClicked: {
                   wizardWindowManager_act_closeRecordingInformationWindows.invoke()
               }
           }
       }
       */
    }    
}
