import QtQuick 2.3

import com.viavi.style 1.0

Rectangle {
    id: button
    // property text color
    property color textColor: ViaviStyle.colors.white
    property color pressedtextColor: textColor
    property int textsize: 20
    property string textDef : "N/A"
    
    // property button
    property color pressColor
    property int durationLongTimer: 1000
    
    property bool enableLongPress: true;
    property bool enableBackOnClick: false;
    
    property bool pressEventAllow: false
    
    property string path_img: "/acterna/storage/look-and-feel/generic/Exit_Wizard.png"

    // property scale
    
    signal pressedButton;
    signal longPressedButton;
    
    opacity: mouseAreaButton.pressed ? 0.8 : 1
    
    function resetButton()
    	{
    	pressEventAllow = false;
        canvas.width = 0     
		buttonAnimation.stop();
    	pressTimer.stop();  
    	}

    Rectangle {
        anchors.centerIn: parent
        width: parent.width
        height: parent.height * 0.75
        anchors.topMargin: 10
        anchors.bottomMargin: 10
        color: "transparent"
        z: 1

        Text {
            id: buttonText
            color: ViaviStyle.colors.white
            width: button.width
            text: textDef
            horizontalAlignment: Text.AlignHCenter
            font.pixelSize: textSize
            font.bold: mouseAreaButton.pressed
            anchors.horizontalCenter: parent.horizontalCenter
            anchors.verticalCenter: enableLongPress == false ? parent.verticalCenter : undefined
            wrapMode: Text.Wrap
        }
        
        Image {
            width: 50
            height: 38
            source: path_img
            fillMode: Image.PreserveAspectFit
            visible: enableLongPress
            anchors.top: buttonText.bottom
            anchors.horizontalCenter: parent.horizontalCenter
            
	        cache: false
			asynchronous: true
        }
    }
    
    MouseArea {
        id: mouseAreaButton
        anchors.fill: parent
        
        onPressed: {
         	pressEventAllow = true;
        } 
        
        onExited: {
        	canvas.width = 0     
			buttonAnimation.stop();
    		pressTimer.stop(); 
        }
        
        onClicked: {
        	if ( pressEventAllow != false )
	        	{
	        	if ( enableLongPress != false )
		        	{
		        	resetButton();
		        	
		        	if ( enableBackOnClick != false )
			        	{
			        	longPressedButton();
			        	}
		        	else
			        	{
			        	pressedButton();
			        	}
		        	}
	        	else
		        	{
		        	resetButton();
		        	pressedButton();
		        	}
	        	}
        }
    }
    
    Rectangle
    {
        id: canvas
        anchors.left: parent.left
        color: Qt.darker(button.color);
        width: 0
        height: parent.height
        radius: 5
        z: 0
    }
    
    PropertyAnimation {
    	id: buttonAnimation
    	target: canvas
    	properties: "width"
    	from: 0
    	to: button.width
    	duration: durationLongTimer
    	running: enableLongPress && mouseAreaButton.pressed
    }
    
    Timer {
        id: pressTimer
        
        interval: durationLongTimer
        repeat: false
        running: enableLongPress && mouseAreaButton.pressed
        
        onTriggered: {
	        resetButton();
			longPressedButton();
        }
    }
}
