import QtQuick 2.5

import com.viavi.style 1.0
import com.viavi.style.components.virtualkeyboard 1.0


KeyboardNumerical{
    id: root

    signal editText(string txtOutput, bool validation)

    property int inputTextMinLength: 1
    inputTextMaxLength: 10


    onAccepted: {
        var len = textField.length
        var validationAllowed = false;
        if (len < inputTextMaxLength && len >= inputTextMinLength ) {
            if (parseFloat(textField) > parseFloat(maxValue))
            {
                validationAllowed = false;
            }
            else if(parseFloat(textField) < parseFloat(minValue))
            {
                validationAllowed = false;
            }
            else
            {
                validationAllowed = true;
            }
        }
        else
        {
            validationAllowed = false;
        }
        editText(textField, validationAllowed);
        root.visible = false
    }

    onConfigurableButtonClicked: {
        wizardSetupData_act_launchCableMeasInfo.invoke()
        root.visible = false
    }

    onCanceled: {
        editText(textField, false);
        root.visible = false
    }

    onInputTextChanged: {
        var len = textField.length
        if (len >= inputTextMinLength ) {
            if (parseFloat(textField) > parseFloat(maxValue)){
                textField = maxValue
                cursorPos = textField.length
            }
            else if(parseFloat(textField) < parseFloat(minValue)){
                textField = minValue
                cursorPos = textField.length
            }
        }
    }
}
