import QtQuick 2.5
import QtQuick.Controls 2.0
import elf_plugin 1.0
import graph_plugin 1.0
import formatters_plugin 1.0

import com.viavi.style 1.0
import com.viavi.style.components 1.0

FocusScope {
    id: rootId

    property int keyPressed: 0
    readonly property int keyCursorDisplacement: 1
    readonly property int keyCursorAcceleratedDisplacement: 5

    readonly property int timerInterval: 100

    property bool additionalCursors: status_res_analysisEnabled.value
                                     && analysis_cfg_measType.enums.emtLoss === analysis_cfg_measType.value
                                     && analysis_cfg_selectedMethod.enums.esm5PtLoss === analysis_cfg_selectedMethod.value

    property bool additionalCursorALock: lastFocusedGraph.additionalCursorALock
    property bool additionalCursorBLock: lastFocusedGraph.additionalCursorBLock

    property CursorDragFiber cursorDragA: lastFocusedGraph.cursorDragA
    property CursorDragFiber cursorDragB: lastFocusedGraph.cursorDragB
    property CursorDragFiber cursorDragAy: lastFocusedGraph.cursorDragAy
    property CursorDragFiber cursorDragBy: lastFocusedGraph.cursorDragBy
    property CursorDragFiber cursorDragAdditionalA: lastFocusedGraph.cursorDragAdditionalA
    property CursorDragFiber cursorDragAdditionalB: lastFocusedGraph.cursorDragAdditionalB
    property CursorDragFiber cursorDragAdditionalC: lastFocusedGraph.cursorDragAdditionalC

    property alias oXAxisVisibleLeft: mainGraph.oXAxisVisibleLeft //to do: make this generic
    property alias oXAxisVisibleRight: mainGraph.oXAxisVisibleRight

    property alias graphCount: mainGraph.graphCount //to do: make this generic
    property alias tailingGraphCount: mainGraph.tailingGraphCount

    property alias secondGraphCount: secondGraph.graphCount
    property alias secondTailingGraphCount: secondGraph.tailingGraphCount

    property alias pressAndHoldTimer: pressAndHoldTimer

    signal keysPressAndHold()
    signal zoomLevelChanged(real xScale, real yScale, real wScale, real hScale)

    //emits when we switch focus between main & second graph
    signal graphFocusChanged(string graphBackendId)

    property string lastFocusedGraphBackendId: mainGraph.graphBackendId //id for default graph
    property FiberViewContainer lastFocusedGraph: mainGraph
    property CursorDragFiber lastUsedCursor: lastFocusedGraph.lastUsedCursor


    function updateLastUsedCursorFromBackend(){
        if(trace_cfg_cursorDraw.value === trace_cfg_cursorDraw.enums.ecDraw_Cursor_X){
            updateLastUsedCursorFromBackendOX();
        }

        if(trace_cfg_cursorDraw.value === trace_cfg_cursorDraw.enums.ecDraw_Cursor_Y){
            updateLastUsedCursorFromBackendOY();
        }

        if(trace_cfg_cursorDraw.value === trace_cfg_cursorDraw.enums.ecDraw_Cursor_XY){
            if(lastUsedCursor === cursorDragA || lastUsedCursor === lastFocusedGraph.cursorDragB){
                updateLastUsedCursorFromBackendOX();
            }
            else if (lastUsedCursor === cursorDragAy || lastUsedCursor === lastFocusedGraph.cursorDragBy){
                updateLastUsedCursorFromBackendOY();
            }
        }
    }

    function updateLastUsedCursorFromBackendOX(){
        if(!additionalCursors){
            if(trace_cfg_cursorSelected.value === trace_cfg_cursorSelected.enums.ecCursor_A){
                lastUsedCursor = cursorDragA;
                lastFocusedGraph.lastUsedCursor = lastUsedCursor;

            }
            else if (trace_cfg_cursorSelected.value === trace_cfg_cursorSelected.enums.ecCursor_B){
                lastUsedCursor = cursorDragB;
                lastFocusedGraph.lastUsedCursor = lastUsedCursor;
            }
        }
    }

    function updateLastUsedCursorFromBackendOY(){
        if(!additionalCursors){
            if(trace_cfg_cursorSelected.value === trace_cfg_cursorSelected.enums.ecCursor_A){
                lastUsedCursor = cursorDragAy
                lastFocusedGraph.lastUsedCursor = lastUsedCursor;
            }
            else if (trace_cfg_cursorSelected.value === trace_cfg_cursorSelected.enums.ecCursor_B){
                lastUsedCursor = cursorDragBy;
                lastFocusedGraph.lastUsedCursor = lastUsedCursor;
            }
        }
    }

    property bool initialised: false
    Connections{
        target: trace_cfg_cursorSelected

        function onValueChanged() {
        	updateLastUsedCursorFromBackend()
        }
    }

    onLastUsedCursorChanged: {
        if(!additionalCursors
                && trace_cfg_cursorSelected.value !== trace_cfg_cursorSelected.enums.ecCursor_AB
                && initialised){
            trace_cfg_cursorSelected.value = lastUsedCursor.backendId
        }

        if (additionalCursors) {
            updateCurrentCursors()
        }
    }

    onAdditionalCursorsChanged: {
        updateLastUsedCursorFromBackend()

        trace_cfg_additionalCursors.value = additionalCursors

        if (additionalCursors) {
            updateCurrentCursors()
        }
    }

    Component.onCompleted: {
        updateLastUsedCursorFromBackend()
        trace_cfg_currentFocusedGraphName.value = lastFocusedGraphBackendId;
        initialised = true
    }

    function keyOnUpPress(){
        if(rootId.visible){
            if(trace_cfg_cursorDraw.value === trace_cfg_cursorDraw.enums.ecDraw_Cursor_X ||
               trace_cfg_cursorDraw.value === trace_cfg_cursorDraw.enums.ecDraw_Cursor_XY)
            {
                lastFocusedGraph.zoomButtonsLayout.zoomBy(1, lastFocusedGraph.zoomButtonsLayout.zoomInFactor)
            }

            if(trace_cfg_cursorDraw.value === trace_cfg_cursorDraw.enums.ecDraw_Cursor_Y)
            {
                if(trace_res_cursorsLocked.value)
                {
                    lastFocusedGraph.zoomButtonsLayout.zoomBy(1, lastFocusedGraph.zoomButtonsLayout.zoomInFactor)
                }
                else
                {
                    rootId.keyPressed = Qt.Key_Up
                    lastFocusedGraph.updateCursorsPosition(keyCursorDisplacement)
                }
            }
        }
    }

    function keyOnDownPress(){
        if(trace_cfg_cursorDraw.value === trace_cfg_cursorDraw.enums.ecDraw_Cursor_X ||
           trace_cfg_cursorDraw.value === trace_cfg_cursorDraw.enums.ecDraw_Cursor_XY)
        {
            lastFocusedGraph.zoomButtonsLayout.zoomBy(1, 1/lastFocusedGraph.zoomButtonsLayout.zoomInFactor)
        }

        if(trace_cfg_cursorDraw.value === trace_cfg_cursorDraw.enums.ecDraw_Cursor_Y)
        {

            if(trace_res_cursorsLocked.value)
            {
                lastFocusedGraph.zoomButtonsLayout.zoomBy(1, 1/lastFocusedGraph.zoomButtonsLayout.zoomInFactor)
            }
            else
            {
                rootId.keyPressed = Qt.Key_Down
                lastFocusedGraph.updateCursorsPosition(-keyCursorDisplacement)
            }
        }

    }

    function keyOnLeftPress(){
        if(rootId.visible){

            if(trace_cfg_cursorDraw.value === trace_cfg_cursorDraw.enums.ecDraw_Cursor_X)
            {
                if(trace_res_cursorsLocked.value){
                    lastFocusedGraph.zoomButtonsLayout.zoomBy(1/lastFocusedGraph.zoomButtonsLayout.zoomInFactor, 1)
                }
                else {
                    rootId.keyPressed = Qt.Key_Left
                    lastFocusedGraph.updateCursorsPosition(-keyCursorDisplacement)
                }
            }

            if(trace_cfg_cursorDraw.value === trace_cfg_cursorDraw.enums.ecDraw_Cursor_Y)
            {
                lastFocusedGraph.zoomButtonsLayout.zoomBy(1/lastFocusedGraph.zoomButtonsLayout.zoomInFactor, 1)
            }

            if(trace_cfg_cursorDraw.value === trace_cfg_cursorDraw.enums.ecDraw_Cursor_XY)
            {
                lastFocusedGraph.zoomButtonsLayout.zoomBy(1/lastFocusedGraph.zoomButtonsLayout.zoomInFactor, 1)
            }
        }
    }

    function keyOnRightPress(){
        if(rootId.visible){

            if(trace_cfg_cursorDraw.value === trace_cfg_cursorDraw.enums.ecDraw_Cursor_X)
            {
                if(trace_res_cursorsLocked.value){
                    lastFocusedGraph.zoomButtonsLayout.zoomBy(lastFocusedGraph.zoomButtonsLayout.zoomInFactor, 1)
                }
                else {
                    rootId.keyPressed = Qt.Key_Right
                    lastFocusedGraph.updateCursorsPosition(keyCursorDisplacement)
                }
            }

            if(trace_cfg_cursorDraw.value === trace_cfg_cursorDraw.enums.ecDraw_Cursor_Y)
            {
                lastFocusedGraph.zoomButtonsLayout.zoomBy(lastFocusedGraph.zoomButtonsLayout.zoomInFactor, 1)
            }

            if(trace_cfg_cursorDraw.value === trace_cfg_cursorDraw.enums.ecDraw_Cursor_XY)
            {
                lastFocusedGraph.zoomButtonsLayout.zoomBy(lastFocusedGraph.zoomButtonsLayout.zoomInFactor, 1)
            }
        }
    }

    Keys.onUpPressed: {
        keyOnUpPress();
    }
    Keys.onDownPressed: {
        keyOnDownPress();
    }
    Keys.onLeftPressed: {
        keyOnLeftPress();
    }
    Keys.onRightPressed: {
        keyOnRightPress();
    }

    Timer {
        id: pressAndHoldTimer
        interval: timerInterval
        running: false
        repeat: true

        onTriggered: {
            rootId.keysPressAndHold();
        }
    }

    onKeysPressAndHold: {
        if(rootId.visible && pressAndHoldTimer.running){
            if(rootId.keyPressed === Qt.Key_Left || rootId.keyPressed === Qt.Key_Down){
                lastFocusedGraph.elfUpdateCursorsPosition.invokeWithStringArg(-keyCursorAcceleratedDisplacement)
            }

            if(rootId.keyPressed === Qt.Key_Right || rootId.keyPressed === Qt.Key_Up){
                lastFocusedGraph.elfUpdateCursorsPosition.invokeWithStringArg(keyCursorAcceleratedDisplacement)
            }
        }
    }

    Keys.onReleased: {
        if(rootId.visible && (event.key === Qt.Key_Left || event.key === Qt.Key_Right ||
                              event.key === Qt.Key_Up || event.key === Qt.Key_Down)){
            pressAndHoldTimer.stop()
        }
    }

    Keys.onReturnPressed: {
        if(rootId.visible){
            trace_act_doAutoZoom.invoke()
        }
    }

    Connections {
        target: getFiberMainPage()
        function onTopLevelUpPressed() {
            keyOnUpPress();
        }
        function onTopLevelDowPressed() {
            keyOnDownPress();
        }
        function onTopLevelLeftPressed() {
            keyOnLeftPress();
        }
        function onTopLevelRightPressed() {
            keyOnRightPress();
        }
        function onTopLevelReturnPressed() {
            if(rootId.visible){
                trace_act_doAutoZoom.invoke()
            }
        }
        function onTopLevelReleased() {
            if(rootId.visible){
                pressAndHoldTimer.stop()
            }
        }
    }



    function onCursorFocusChanged(cursorDrag){
        if (lastUsedCursor !== cursorDrag){
            lastUsedCursor = cursorDrag;
        }
    }

    function changeLastFocusedCursor(cursorDrag){
        if (lastFocusedGraph.lastUsedCursor !== cursorDrag){
            lastFocusedGraph.lastUsedCursor = cursorDrag;
        }
        onCursorFocusChanged(cursorDrag);
    }

    function onGraphFocusedChanged(graphBackendId, fiberViewContainer){
        if(lastFocusedGraphBackendId !== graphBackendId){
            lastFocusedGraphBackendId = graphBackendId;
            lastFocusedGraph = fiberViewContainer;
            graphFocusChanged(graphBackendId);

            updateLastUsedCursorFromBackend();
        }
    }

    function setAdditionalCursorALock(value){
        additionalCursorALock = value
        lastFocusedGraph.additionalCursorALock = value;
    }

    function setAdditionalCursorBLock(value){
        additionalCursorBLock = value
        lastFocusedGraph.additionalCursorBLock = value;
    }

    function updateCurrentCursors() {
        if (additionalCursors) {
            if (lastUsedCursor == cursorDragA) {
                if (lastUsedCursor.connectedCursor) {
                    trace_cfg_currentCursor.value = trace_cfg_currentCursor.enums.eCursor_Aa
                    trace_cfg_cursorSelected.value = trace_cfg_currentCursor.enums.eCursor_Aa
                }
                else {
                    trace_cfg_currentCursor.value = trace_cfg_currentCursor.enums.eCursor_A
                    trace_cfg_cursorSelected.value = trace_cfg_currentCursor.enums.eCursor_A
                }
            }
            else if (lastUsedCursor == cursorDragB) {
                if (lastUsedCursor.connectedCursor) {
                    trace_cfg_currentCursor.value = trace_cfg_currentCursor.enums.eCursor_Bb
                    trace_cfg_cursorSelected.value = trace_cfg_currentCursor.enums.eCursor_Bb
                }
                else {
                    trace_cfg_currentCursor.value = trace_cfg_currentCursor.enums.eCursor_B
                    trace_cfg_cursorSelected.value = trace_cfg_currentCursor.enums.eCursor_B
                }
            }
            else if (lastUsedCursor == cursorDragAdditionalA) {
                if (lastUsedCursor.connectedCursor) {
                    trace_cfg_currentCursor.value = trace_cfg_currentCursor.enums.eCursor_Aa
                    trace_cfg_cursorSelected.value = trace_cfg_currentCursor.enums.eCursor_Aa
                }
                else {
                    trace_cfg_currentCursor.value = trace_cfg_currentCursor.enums.eCursor_a
                    trace_cfg_cursorSelected.value = trace_cfg_currentCursor.enums.eCursor_a
                }
            }
            else if (lastUsedCursor == cursorDragAdditionalB) {
                if (lastUsedCursor.connectedCursor) {
                    trace_cfg_currentCursor.value = trace_cfg_currentCursor.enums.eCursor_Bb
                    trace_cfg_cursorSelected.value = trace_cfg_currentCursor.enums.eCursor_Bb
                }
                else {
                    trace_cfg_currentCursor.value = trace_cfg_currentCursor.enums.eCursor_b
                    trace_cfg_cursorSelected.value = trace_cfg_currentCursor.enums.eCursor_b
                }
            }
            else if (lastUsedCursor == cursorDragAdditionalC) {
                trace_cfg_currentCursor.value = trace_cfg_currentCursor.enums.eCursor_c
                trace_cfg_cursorSelected.value = trace_cfg_currentCursor.enums.eCursor_c
            }
            else {
                trace_cfg_currentCursor.value = trace_cfg_currentCursor.enums.eNo_Cursor
                trace_cfg_cursorSelected.value = trace_cfg_currentCursor.enums.eNo_Cursor
            }
        }
    }



    FiberViewContainer{
        id:mainGraph
        graphBackendId: "0_"
        anchors.fill: rootId
        anchors.bottomMargin: secondGraph.visible ? rootId.height/2 : 0
        traceComponent: rootId
    }

    FiberViewContainer{
        id:secondGraph
        graphBackendId: "1_"
        anchors.fill: rootId
        anchors.topMargin: rootId.height/2
        anchors.bottomMargin:  0
        traceComponent: rootId
    }

}
