import QtQuick 2.3
import QtQuick.Controls 2.0

import com.viavi.style 1.0


MouseArea {
	height : text.height
	width : 2 * text.width

	property bool rightStyle: false
	
	Text {
	    id: text
	    
	    anchors.verticalCenter : parent.verticalCenter
	    
	    x: (parent.width - width) / 2 
	    	+ (parent.rightStyle ? 1 : -1)
	    		* (parent.pressed ? width / 3 : 0) 
	    
	    font.pointSize: 20 //in case the elemnt isn't transformed and it uses an image add the font in viavi style
	    
	 
	 	
	 
	    text: parent.rightStyle ? ">" : "<"
	    
	    color: ViaviStyle.colors.activeColor
	    
	}
}
	
