import QtQuick 2.3
import QtQuick.Controls 2.8
import QtQuick.Layouts 1.2

import com.viavi.style 1.0
import com.viavi.style.components 1.0
import libsetupmenu 1.0

ColumnLayout {
    ViaviMenuLineInputText {
        text: menuOtdr.acquisitionPage.switchPort.name.text
        textData.text: menuOtdr.acquisitionPage.switchPort.value
        onTextClicked: menuOtdr.acquisitionPage.switchPort.validateValue()
        visible: menuOtdr.acquisitionPage.switchPort.available
        enabled: menuOtdr.acquisitionPage.switchPort.enabled
    }

    ViaviMenuLineMultiOption{
        id: laser
        text: menuOtdr.acquisitionPage.laserFrequency.name.text
        model: menuOtdr.acquisitionPage.laserFrequency.multiOptionModel
        Layout.fillWidth: true

        onSgnOptionClicked: {
            menuOtdr.acquisitionPage.laserFrequency.validateOption(index)
        }
    }

    ViaviMenuLineMultiOption{
        id: acquisitionMode

        enabled: menuOtdr.acquisitionPage.acquisitionMode.enabled
        visible: menuOtdr.acquisitionPage.acquisitionMode.available

        text: menuOtdr.acquisitionPage.acquisitionMode.name.text
        model: menuOtdr.acquisitionPage.acquisitionMode.multiOptionModel
        Layout.fillWidth: true

        onSgnOptionClicked: {
            menuOtdr.acquisitionPage.acquisitionMode.validateOption(index)
        }
    }

    MenuSeparator { Layout.fillWidth: true }

    ViaviMenuLineComboText {
        id: range

        enabled: menuOtdr.acquisitionPage.range.enabled
        visible: menuOtdr.acquisitionPage.range.available

        text: menuOtdr.acquisitionPage.range.name.text
        comboBoxData.model: menuOtdr.acquisitionPage.range.multiOptionModel

        comboBoxData.onCurrentIndexChanged: {
            menuOtdr.acquisitionPage.range.validateOption(comboBoxData.currentIndex)
        }

        comboBoxData.currentIndex: menuOtdr.acquisitionPage.range.selectedIndex

        Connections {
            target:  menuOtdr.acquisitionPage.range
            function onSelectedIndexChanged() { 
                range.comboBoxData.currentIndex = menuOtdr.acquisitionPage.range.selectedIndex
            }
        }

        textData.text: menuOtdr.acquisitionPage.rangeInput.value
        textData.enabled: menuOtdr.acquisitionPage.manualAcqMode.enabled
        textData.visible: menuOtdr.acquisitionPage.manualAcqMode.available
        onTextClicked: { menuOtdr.acquisitionPage.rangeInput.validateValue(); }
    }

    ViaviMenuLineComboText{
        id: pulse

        enabled: menuOtdr.acquisitionPage.pulse.enabled
        visible: menuOtdr.acquisitionPage.pulse.available

        text: menuOtdr.acquisitionPage.pulse.name.text
        comboBoxData.model: menuOtdr.acquisitionPage.pulse.multiOptionModel

        comboBoxData.onCurrentIndexChanged: {
            menuOtdr.acquisitionPage.pulse.validateOption(comboBoxData.currentIndex)
        }

        comboBoxData.currentIndex: menuOtdr.acquisitionPage.pulse.selectedIndex

        Connections {
            target:  menuOtdr.acquisitionPage.pulse
            function onSelectedIndexChanged() { 
                pulse.comboBoxData.currentIndex = menuOtdr.acquisitionPage.pulse.selectedIndex
            }
        }
        textData.text: menuOtdr.acquisitionPage.pulseInput.value
        textData.enabled: menuOtdr.acquisitionPage.pulseInput.enabled
        textData.visible: menuOtdr.acquisitionPage.pulseInput.available
        onTextClicked: { menuOtdr.acquisitionPage.pulseInput.validateValue(); }
    }

    ViaviMenuLineComboBox{
        id: resolution

        enabled: menuOtdr.acquisitionPage.resolution.enabled
        visible: menuOtdr.acquisitionPage.resolution.available

        text: menuOtdr.acquisitionPage.resolution.name.text
        comboBoxData.model: menuOtdr.acquisitionPage.resolution.multiOptionModel

        comboBoxData.onCurrentIndexChanged: {
            menuOtdr.acquisitionPage.resolution.validateOption(comboBoxData.currentIndex)
        }

        comboBoxData.currentIndex: menuOtdr.acquisitionPage.resolution.selectedIndex

        Connections {
            target:  menuOtdr.acquisitionPage.resolution
            function onSelectedIndexChanged() { 
                resolution.comboBoxData.currentIndex = menuOtdr.acquisitionPage.resolution.selectedIndex
            }
        }
    }

    ViaviMenuLineComboText {
        id: acquisitionTime

        enabled: menuOtdr.acquisitionPage.acquisitionTime.enabled
        visible: menuOtdr.acquisitionPage.acquisitionTime.available

        text: menuOtdr.acquisitionPage.acquisitionTime.name.text
        comboBoxData.model: menuOtdr.acquisitionPage.acquisitionTime.multiOptionModel

        comboBoxData.onCurrentIndexChanged: {
            menuOtdr.acquisitionPage.acquisitionTime.validateOption(comboBoxData.currentIndex)
        }

        comboBoxData.currentIndex: menuOtdr.acquisitionPage.acquisitionTime.selectedIndex

        Connections {
            target:  menuOtdr.acquisitionPage.acquisitionTime
            function onSelectedIndexChanged() { 
                acquisitionTime.comboBoxData.currentIndex = menuOtdr.acquisitionPage.acquisitionTime.selectedIndex
            }
        }
        textData.text: menuOtdr.acquisitionPage.acquisitionTimeInput.value
        textData.enabled: menuOtdr.acquisitionPage.acquisitionTimeInput.enabled
        textData.visible: menuOtdr.acquisitionPage.acquisitionTimeInput.available
        onTextClicked: { menuOtdr.acquisitionPage.acquisitionTimeInput.validateValue(); }
    }

    MenuSeparator { Layout.fillWidth: true }

    ViaviMenuLineCheckComboText {
        id: launchCable
        text: menuOtdr.acquisitionPage.launchCable.name.text

        checkBoxData.checked: menuOtdr.acquisitionPage.launchCable.switch
        checkBoxData.enabled: menuOtdr.acquisitionPage.launchCable.enabled
        checkBoxData.visible: menuOtdr.acquisitionPage.launchCable.available

        onSgnToggled: { menuOtdr.acquisitionPage.launchCable.validateSwitch(value);}

        comboBoxData.visible: menuOtdr.acquisitionPage.launchCable.switch
        comboBoxData.model: menuOtdr.acquisitionPage.launchCableModel.multiOptionModel

        comboBoxData.onCurrentIndexChanged: {
            menuOtdr.acquisitionPage.launchCableModel.validateOption(comboBoxData.currentIndex)
        }

        comboBoxData.currentIndex: menuOtdr.acquisitionPage.launchCableModel.selectedIndex

        Connections {
            target:  menuOtdr.acquisitionPage.launchCableModel
            function onSelectedIndexChanged() { 
                launchCable.comboBoxData.currentIndex = menuOtdr.acquisitionPage.launchCableModel.selectedIndex
            }
        }
        textData.text: menuOtdr.acquisitionPage.launchCableInput.value
        textData.enabled: menuOtdr.acquisitionPage.launchCableInput.enabled
        textData.visible: menuOtdr.acquisitionPage.launchCableInput.available && checkBoxData.checked
        onTextClicked: { menuOtdr.acquisitionPage.launchCableInput.validateValue(); }
    }

    ViaviMenuLineSwitch_YesNo {
        id: includeLinkStartConnector

        enabled: menuOtdr.acquisitionPage.launchCable.switch
        visible: menuOtdr.acquisitionPage.launchCable.switch
        text: menuOtdr.acquisitionPage.includeLinkStartConnector.name.text

        checked: menuOtdr.acquisitionPage.includeLinkStartConnector.switch

        onSgnSwitch: {
            menuOtdr.acquisitionPage.includeLinkStartConnector.validateSwitch(value)
        }
    }

    ViaviMenuLineCheckComboText {
        id: receiveCable
        text: menuOtdr.acquisitionPage.receiveCable.name.text

        checkBoxData.checked: menuOtdr.acquisitionPage.receiveCable.switch
        checkBoxData.enabled: menuOtdr.acquisitionPage.receiveCable.enabled
        checkBoxData.visible: menuOtdr.acquisitionPage.receiveCable.available

        onSgnToggled: { menuOtdr.acquisitionPage.receiveCable.validateSwitch(value);}

        comboBoxData.visible: menuOtdr.acquisitionPage.receiveCable.switch == true
        comboBoxData.model: menuOtdr.acquisitionPage.receiveCableModel.multiOptionModel

        comboBoxData.onCurrentIndexChanged: {
            menuOtdr.acquisitionPage.receiveCableModel.validateOption(comboBoxData.currentIndex)
        }

        comboBoxData.currentIndex: menuOtdr.acquisitionPage.receiveCableModel.selectedIndex
         
        Connections {
            target:  menuOtdr.acquisitionPage.receiveCableModel
            function onSelectedIndexChanged() { 
                receiveCable.comboBoxData.currentIndex = menuOtdr.acquisitionPage.receiveCableModel.selectedIndex
            }
        }

        textData.text: menuOtdr.acquisitionPage.receiveCableInput.value
        textData.enabled: menuOtdr.acquisitionPage.receiveCableInput.enabled
        textData.visible: menuOtdr.acquisitionPage.receiveCableInput.available && checkBoxData.checked
        onTextClicked: { menuOtdr.acquisitionPage.receiveCableInput.validateValue(); }
    }

    ViaviMenuLineSwitch_YesNo {
        id: includeLinkEndConnector

        enabled: menuOtdr.acquisitionPage.receiveCable.switch
        visible: menuOtdr.acquisitionPage.receiveCable.switch
        text: menuOtdr.acquisitionPage.includeLinkEndConnector.name.text

        checked: menuOtdr.acquisitionPage.includeLinkEndConnector.switch

        onSgnSwitch: {
            menuOtdr.acquisitionPage.includeLinkEndConnector.validateSwitch(value)
        }
    }

    ViaviMenuLineComboBox {
        id: connectorTest

        enabled: menuOtdr.acquisitionPage.connectorTest.enabled
        visible: menuOtdr.acquisitionPage.connectorTest.available

        text: menuOtdr.acquisitionPage.connectorTest.name.text
        comboBoxData.model: menuOtdr.acquisitionPage.connectorTest.multiOptionModel

        comboBoxData.onCurrentIndexChanged: {
            menuOtdr.acquisitionPage.connectorTest.validateOption(comboBoxData.currentIndex)
        }

        comboBoxData.currentIndex: menuOtdr.acquisitionPage.connectorTest.selectedIndex

        Connections {
            target:  menuOtdr.acquisitionPage.connectorTest
            function onSelectedIndexChanged() { 
                connectorTest.comboBoxData.currentIndex = menuOtdr.acquisitionPage.connectorTest.selectedIndex
            }
        }
    }


    MenuSeparator { Layout.fillWidth: true }

    ViaviMenuLineComboBox {
        id: nbOfSplitters

        enabled: menuOtdr.acquisitionPage.nbOfSplitters.enabled
        visible: menuOtdr.acquisitionPage.nbOfSplitters.available

        text: menuOtdr.acquisitionPage.nbOfSplitters.name.text
        comboBoxData.model: menuOtdr.acquisitionPage.nbOfSplitters.multiOptionModel

        comboBoxData.onCurrentIndexChanged: {
            menuOtdr.acquisitionPage.nbOfSplitters.validateOption(comboBoxData.currentIndex)
        }

        comboBoxData.currentIndex: menuOtdr.acquisitionPage.nbOfSplitters.selectedIndex

        Connections {
            target:  menuOtdr.acquisitionPage.nbOfSplitters
            function onSelectedIndexChanged() {
                nbOfSplitters.comboBoxData.currentIndex = menuOtdr.acquisitionPage.nbOfSplitters.selectedIndex
            }
        }
    }

    PliableControl {
        visible: typeSplitter1.visible || typeSplitter2.visible || typeSplitter3.visible
        title: 'From OLT to ONT'

        ViaviMenuLineComboBox {
            id: typeSplitter1

            enabled: menuOtdr.acquisitionPage.typeSplitter1.enabled
            visible: menuOtdr.acquisitionPage.typeSplitter1.available

            text: menuOtdr.acquisitionPage.typeSplitter1.name.text

            comboBoxData.model: menuOtdr.acquisitionPage.typeSplitter1.multiOptionModel

            comboBoxData.onCurrentIndexChanged: {
                menuOtdr.acquisitionPage.typeSplitter1.validateOption(comboBoxData.currentIndex)
            }

            //comboBoxData.currentIndex: menuOtdr.acquisitionPage.typeSplitter1.selectedIndex

            Connections {
                target:  menuOtdr.acquisitionPage.typeSplitter1
                function onSelectedIndexChanged() { 
                    typeSplitter1.comboBoxData.currentIndex = menuOtdr.acquisitionPage.typeSplitter1.selectedIndex
                }
            }
        }

        ViaviMenuLineComboBox {
            id: typeSplitter2

            enabled: menuOtdr.acquisitionPage.typeSplitter2.enabled
            visible: menuOtdr.acquisitionPage.typeSplitter2.available

            text: menuOtdr.acquisitionPage.typeSplitter2.name.text

            comboBoxData.model: menuOtdr.acquisitionPage.typeSplitter2.multiOptionModel

            comboBoxData.onCurrentIndexChanged: {
                menuOtdr.acquisitionPage.typeSplitter2.validateOption(comboBoxData.currentIndex)
            }

            //comboBoxData.currentIndex: menuOtdr.acquisitionPage.typeSplitter2.selectedIndex

            Connections {
                target:  menuOtdr.acquisitionPage.typeSplitter2
                function onSelectedIndexChanged() { 
                    typeSplitter2.comboBoxData.currentIndex = menuOtdr.acquisitionPage.typeSplitter2.selectedIndex
                }
            }
        }

        ViaviMenuLineComboBox {
            id: typeSplitter3

            enabled: menuOtdr.acquisitionPage.typeSplitter3.enabled
            visible: menuOtdr.acquisitionPage.typeSplitter3.available

            text: menuOtdr.acquisitionPage.typeSplitter3.name.text

            comboBoxData.model: menuOtdr.acquisitionPage.typeSplitter3.multiOptionModel

            comboBoxData.onCurrentIndexChanged: {
                menuOtdr.acquisitionPage.typeSplitter3.validateOption(comboBoxData.currentIndex)
            }

            //comboBoxData.currentIndex: menuOtdr.acquisitionPage.typeSplitter3.selectedIndex

            Connections {
                target:  menuOtdr.acquisitionPage.typeSplitter3
                function onSelectedIndexChanged() { 
                    typeSplitter3.comboBoxData.currentIndex = menuOtdr.acquisitionPage.typeSplitter3.selectedIndex
                }
            }
        }
    }

    PliableControl {
        title: menuOtdr.acquisitionPage.unbalancedTapsSubcategory.name.text
        visible: menuOtdr.acquisitionPage.unbalancedTapsSubcategory.available
        ViaviMenuLineMultiOption {
            id: unbalancedMode

            Layout.fillWidth: true
            enabled: menuOtdr.acquisitionPage.unbalancedMode.enabled
            visible: menuOtdr.acquisitionPage.unbalancedMode.available

            text: menuOtdr.acquisitionPage.unbalancedMode.name.text
            model: menuOtdr.acquisitionPage.unbalancedMode.multiOptionModel

            onSgnOptionClicked: {
                menuOtdr.acquisitionPage.unbalancedMode.validateOption(index)
            }
        }

        ViaviMenuLineComboBox {
            id: nbOfTaps
            text: menuOtdr.acquisitionPage.nbOfTaps.name.text
            visible: comboBoxData.visible
            
            comboBoxData.model: menuOtdr.acquisitionPage.nbOfTaps.multiOptionModel
            comboBoxData.enabled: menuOtdr.acquisitionPage.nbOfTaps.enabled
            comboBoxData.visible: menuOtdr.acquisitionPage.nbOfTaps.available

            comboBoxData.onCurrentIndexChanged: {
                menuOtdr.acquisitionPage.nbOfTaps.validateOption(comboBoxData.currentIndex)
            }

            comboBoxData.currentIndex: menuOtdr.acquisitionPage.nbOfTaps.selectedIndex

            Connections {
                target:  menuOtdr.acquisitionPage.nbOfTaps
                function onSelectedIndexChanged() {

                    nbOfTaps.comboBoxData.currentIndex = menuOtdr.acquisitionPage.nbOfTaps.selectedIndex
                }
            }
        }

        ViaviMenuLineComboBox {
            id: testPort
            text: menuOtdr.acquisitionPage.testPort.name.text
            visible: comboBoxData.visible

            comboBoxData.model: menuOtdr.acquisitionPage.testPort.multiOptionModel 
            comboBoxData.enabled: menuOtdr.acquisitionPage.testPort.enabled
            comboBoxData.visible: menuOtdr.acquisitionPage.testPort.available

            comboBoxData.currentIndex: menuOtdr.acquisitionPage.testPort.selectedIndex

            comboBoxData.onCurrentIndexChanged: {
                menuOtdr.acquisitionPage.testPort.validateOption(comboBoxData.currentIndex)
            }
            Connections {
                target: menuOtdr.acquisitionPage.testPort
                function onSelectedIndexChanged() {
                    testPort.comboBoxData.currentIndex = menuOtdr.acquisitionPage.testPort.selectedIndex;
                }
            }
        }

        ViaviMenuLineComboBox {
            id: dropSplitter
            text: menuOtdr.acquisitionPage.dropSplitter.name.text
            visible: comboBoxData.visible

            comboBoxData.model: menuOtdr.acquisitionPage.dropSplitter.multiOptionModel 
            comboBoxData.enabled: menuOtdr.acquisitionPage.dropSplitter.enabled
            comboBoxData.visible: menuOtdr.acquisitionPage.dropSplitter.available

            comboBoxData.currentIndex: menuOtdr.acquisitionPage.dropSplitter.selectedIndex

            comboBoxData.onCurrentIndexChanged: {
                menuOtdr.acquisitionPage.dropSplitter.validateOption(comboBoxData.currentIndex)
            }
            Connections {
                target: menuOtdr.acquisitionPage.dropSplitter
                function onSelectedIndexChanged() {
                    dropSplitter.comboBoxData.currentIndex = menuOtdr.acquisitionPage.dropSplitter.selectedIndex;
                }
            }
        }



        Loader{
            Component{
                id: forOLTONTComponent
                PliableControl {
                    title: menuOtdr.acquisitionPage.forOLTONTLabel.name.text
                    visible: menuOtdr.acquisitionPage.nbOfTaps.available

                    GridLayout {
                        columns: 3
                        columnSpacing: ViaviStyle.layout.largeMargin * 10

                        Text {
                            text: ""
                        }

                        Text {
                        text: menuOtdr.acquisitionPage.unbalancedTapsLabel.name.text
                        }

                        Text {
                        text: menuOtdr.acquisitionPage.testPointLabel.name.text
                        }
                    }

                    Repeater {
                        model: menuOtdr.acquisitionPage.tapsTestPointsModel
                        ViaviMenuLineComboCheck
                        {
                            id: tapItem
                            text: model.index + 1
                            property Menu_Item_Switch checkboxBackendData:  model.testPoint

                            checkBoxData.checked: checkboxBackendData.switch

                            onSgnToggled: { 
                                checkboxBackendData.validateSwitch(value);
                            }


                            property Menu_Item_Multi_Option comboboxBackendData: model.tap

                            comboBoxData.model: comboboxBackendData.multiOptionModel
                            comboBoxData.enabled: comboboxBackendData.enabled
                            comboBoxData.visible: comboboxBackendData.available

                            comboBoxData.currentIndex: comboboxBackendData.selectedIndex

                            comboBoxData.onCurrentIndexChanged: {
                                comboboxBackendData.validateOption(comboBoxData.currentIndex)
                            }

                            Connections {
                                target: tapItem.comboboxBackendData
                                function onSelectedIndexChanged() {
                                   tapItem.comboBoxData.currentIndex = tapItem.comboboxBackendData.selectedIndex;
                                }
                            }
                        }
                    }

                    ViaviMenuLineCheckBox {
                       text: menuOtdr.acquisitionPage.testDropSplitter.name.text
                       checkBoxData.checked: menuOtdr.acquisitionPage.testDropSplitter.switch
                       onSgnToggled:{
                           menuOtdr.acquisitionPage.testDropSplitter.validateSwitch(value);
                       }
                    }
                }
            }
            sourceComponent: forOLTONTComponent
            active: menuOtdr.acquisitionPage.nbOfTaps.available
        }       
    }
}
