import QtQuick 2.3

import com.viavi.style 1.0

Rectangle {
    id: container

    width: IsMultiEvtGroup ? SxSize + 10 : SxSize
    /* used actual parent.height to remove delegate error */
    height: 100
    
    color: "transparent"
    
    // return alarm color due to AlarmStatus value
    function getAlarmColor( AlarmStatus ) 
    {
      var alarm_color = ViaviStyle.colors.slmPurple
      
      switch( AlarmStatus )
      {
      case -2:
         alarm_color = ViaviStyle.colors.yellow;
         break;
      case -1:
         alarm_color = ViaviStyle.colors.red;
         break;
      case 1:
         alarm_color = ViaviStyle.colors.green;
         break;
      default:
         alarm_color = ViaviStyle.colors.slmPurple;
         break;
      }
      
      return alarm_color;
    }

    Row{
        anchors.fill: parent

        anchors.topMargin: 10
        anchors.leftMargin: IsMultiEvtGroup ? 5 : 0
        anchors.rightMargin: IsMultiEvtGroup ? 5 : 0

        Repeater {
            id: listDescription

            model: EvtModel
            delegate: Schematic_View_Event_Description_Item { height: container.height }
        }
    }

    Rectangle {
        anchors.horizontalCenter: parent.horizontalCenter
        anchors.top: parent.top
        anchors.topMargin: 23
        
        visible: IsMultiEvtGroup

        radius: 10

        border.color: getAlarmColor(AlarmStatus)
        border.width: 2

        color: "transparent"

        width: parent.width - 2
        height: 54
    }
}
