import QtQuick 2.5
import QtQuick.Layouts 1.1

import com.viavi.style 1.0
import com.viavi.style.components 1.0
import com.viavi.fiberutilui.components 1.0
import com.viavi.fiberutilui 1.0

BasicContainer {
    id: slmContainer

    property int windowHeight: height
    property int windowWidth: width

    property int eventHeight: windowHeight * 0.45
    property int eventWidth: eventHeight * 1.25

    property int listBottomMargin: unitText.contentHeight + ViaviStyle.layout.mediumMargin

    property int minConnLength: eventWidth * 0.65

    property int listDelegateHeight: eventHeight                    //event
                                     + ViaviStyle.layout.mediumMargin      //text margins top and bottom
                                     + 2 * unitText.contentHeight   //labels top and bottom
                                     + 10

    property bool detailModeAlwaysOn: false

    readonly property int alarmStatusFailed: -1

    property FiberPopup eventPopup

    property double firstItemDistance
    property double lastItemDistance
    
    property int groupSelected: schematic_cfg_slmCurrentGroupEvent.value


    SlmUtils { id: slmUtils }

    // Item for displaying the event list
    Item {
        id: itemListContainer

        visible: schematic_res_slmNotEmpty.value

        height: listDelegateHeight

        anchors.bottom: parent.bottom
        anchors.bottomMargin: listBottomMargin
        anchors.right: parent.right
        anchors.rightMargin: ViaviStyle.layout.largeMargin
        anchors.left: parent.left
        anchors.leftMargin: ViaviStyle.layout.largeMargin

        clip:true

        ListView {
            id: eventListView

            anchors.fill: parent

            anchors.rightMargin: ViaviStyle.layout.smallMargin
            anchors.leftMargin: ViaviStyle.layout.smallMargin

            model: schematic_res_slmEventList.value
            currentIndex: schematic_cfg_slmCurrentEvent.value

            orientation: ListView.Horizontal
            boundsBehavior: Flickable.StopAtBounds

            property bool isListCompleted : false
            property double cursorPosX: 0.

            focus:true

            onContentXChanged: {
                /* indexAt should be called only after the Component is completed */
                if ( eventListView.isListCompleted === true ) {
                    eventListView.updateFirstLastEvent()
                }
            }

            onContentWidthChanged: {
                /* indexAt should be called only after the Component is completed */
                if ( eventListView.isListCompleted === true ) {
                    eventListView.updateFirstLastEvent()
                }
            }
            onMovementEnded: {
                //save cursor position
                cursorPosX = eventListView.contentX
            }

            function updateFirstLastEvent(){
                var startItem = eventListView.itemAt(eventListView.contentX, eventListView.height * 0.5 )


                if(startItem){
                    slmContainer.firstItemDistance = startItem.distance
                }

                //if contentWidth is smaller than list width it means that the last elemnt is visible
                //min makes sure that element is selected and not something outside the list which would return 0
                var endItem = eventListView.itemAt( Math.min(eventListView.contentX + eventListView.width - eventWidth
                                               ,eventListView.contentX + eventListView.contentWidth -1)
                                     , eventListView.height * 0.5 );
                if(endItem){
                    slmContainer.lastItemDistance = endItem.distance
                }
            }

            function initFirstLastValue(){
                if(eventListView.isListCompleted
                        && eventListView.count > 0
                        ){

                    eventListView.positionViewAtIndex( eventListView.currentIndex , ListView.Center );
                    eventListView.forceLayout()
                    eventListView.updateFirstLastEvent()
                }
            }

            //initFirstLastValue must be called after component is completed
            //and whenever the events in the list have modified
            //it uses forceLayout so it should change whenever the color of the events change
            //whith the current setup I managed to get it to be called every time.
            //(onCompleted and on

            Component.onCompleted: {
                eventListView.isListCompleted = true
                eventListView.initFirstLastValue()
            }

            onCountChanged: {
                eventListView.initFirstLastValue()
                //restor cursor position (else it's reset)
                eventListView.contentX = cursorPosX
            }

            // event list delegatel
            delegate: Item {
                id: eventListDelegate

                property bool isSelectedEvent: ( schematic_cfg_slmCurrentEvent.value === model.eventIndex ) &&
                                               ( schematic_cfg_slmDetailedMode.value === schematic_cfg_slmDetailedMode.enums.edmEvent )
                property bool isSelectedLink: ( schematic_cfg_slmCurrentEvent.value - 1 === model.eventIndex ) &&
                                               ( schematic_cfg_slmDetailedMode.value === schematic_cfg_slmDetailedMode.enums.edmLink )
                                               
				property bool isGroupEventSelected: ( slmContainer.groupSelected == model.groupNumber ) && ( slmContainer.groupSelected != -1 )


                property bool isFirstEntryPlacholder: (model.index === 0 && schematic_cfg_slmShowFirstEntryPlaceholder.value)

                property double distance: model.eventDistance

                width: event.width + connection.width
                height: listDelegateHeight

                function clickItem(isEvent){

                }
                
                Rectangle {
                	id: groupArea
                	
                	z: -1
                	
                    anchors.top: groupTopLine.top
                    anchors.bottom: groupBottomLine.bottom
                	anchors.left: parent.left
                    anchors.right: model.groupElementType !== schematic_res_groupElementTypeEnum.enums.egetEnd
                                    ? parent.right : groupRightLine.right
                                    
                    color: isGroupEventSelected ? ViaviStyle.colors.activeColor : "transparent"
                }
                
                MouseArea {
                	id: mainMouseArea
                	
                	enabled: model.groupNumber != -1 && schematic_res_groupEventAllowed.value
                	
                	anchors.top: groupTopLine.top
                    anchors.bottom: groupBottomLine.bottom
                	anchors.left: parent.left
                    anchors.right: model.groupElementType !== schematic_res_groupElementTypeEnum.enums.egetEnd
                                    ? parent.right : groupRightLine.right
                                    
                    onClicked: {
                    	if ( slmContainer.groupSelected == model.groupNumber ) {
                    		schematic_cfg_slmCurrentGroupEvent.value = -1
                    		schematic_cfg_slmDetailedMode.value = schematic_cfg_slmDetailedMode.enums.edmOff;
                    	}
                    	else {
                    		schematic_cfg_slmCurrentGroupEvent.value = model.groupNumber
                    		schematic_cfg_slmCurrentEvent.value = model.eventIndex;
                    		schematic_cfg_slmDetailedMode.value = schematic_cfg_slmDetailedMode.enums.edmGroup;
                    	}
                    }
                }

                Rectangle {

                    id: event
                    width: eventWidth
                    height: eventHeight

                    anchors.left: parent.left
                    anchors.leftMargin: ViaviStyle.layout.smallMargin / 2

                    opacity: isSelectedEvent || isGroupEventSelected ? 1: schematic_cfg_slmDetailedMode.value === schematic_cfg_slmDetailedMode.enums.edmOff ? 1.0 : 0.5

                    anchors.verticalCenter: parent.verticalCenter

                    radius: 3
                    color: isSelectedEvent ? ViaviStyle.colors.activeColor : "white"

                    border.color: isSelectedEvent ? "transparent" : ViaviStyle.colors.getColor(model.alarmStatus)
                    border.width: isFirstEntryPlacholder ? 0 : ViaviStyle.layout.borderSize

                    ColorImage {
                        id: eventIcon
                        width: isFirstEntryPlacholder ? eventWidth : eventWidth * 0.65
                        height: isFirstEntryPlacholder ? eventWidth : eventHeight

                        anchors.centerIn: parent
                        source: model.eventIconPath
                        fillMode: Image.PreserveAspectFit
                        smooth: true
                        
                        color: isSelectedEvent ? ViaviStyle.colors.activeItemTextColor : ViaviStyle.colors.activeColor
                    }

                    // Indicator image displayed on top of eventIcon
                    Image {
                        visible: model.eventIconIndicator !== ""
                        width: isFirstEntryPlacholder ? eventWidth : eventWidth * 0.65
                        height: isFirstEntryPlacholder ? eventWidth : eventHeight

                        anchors.centerIn: parent
                        source: model.eventIconIndicator
                        fillMode: Image.PreserveAspectFit
                        smooth: true
                    }

                    PopupMouseArea {
                        id: eventLongPressArea

                        enabled: isFirstEntryPlacholder ? false : true
                        anchors.fill: parent
                        z: parent.z + 1

                        longPressMenu: eventPopup

                        onBeforePressAndHold: {
                            schematic_cfg_slmCurrentEvent.value = model.eventIndex
                            schematic_cfg_slmDetailedMode.value = schematic_cfg_slmDetailedMode.enums.edmEvent
                        }

                        onClicked: {
                            if(!schematic_res_isMotfDataVisible.value) {
                            	schematic_cfg_slmCurrentGroupEvent.value = -1
                            
                                if ( isSelectedEvent ) {
                                	//tried to update it from cpp to true in fcomp but value doesn't get back to qml correctly so
                                	if(!slmContainer.detailModeAlwaysOn) {
                                    	schematic_cfg_slmDetailedMode.value = schematic_cfg_slmDetailedMode.enums.edmOff;
                                	}
                                } 
                                else {
                                	schematic_cfg_slmDetailedMode.value = schematic_cfg_slmDetailedMode.enums.edmEvent;
                                	schematic_cfg_slmCurrentEvent.value = model.eventIndex;
                                }
                                
                                
                            }

                        }

                    }

                    ColorImage {
                        visible: model.alarmStatus !== 0 /* event is tested */
                        width: parent.width * 0.2

                        anchors.top: parent.top
                        anchors.topMargin: ViaviStyle.layout.smallMargin

                        anchors.right: parent.right
                        anchors.rightMargin: ViaviStyle.layout.smallMargin

                        source: model.alarmStatus === alarmStatusFailed ? /* event failed */
                                                           FiberStyle.images.iconFailedEvent : FiberStyle.images.iconPassedEvent
                        fillMode: Image.PreserveAspectFit
                        smooth: true

                        color:  model.alarmStatus === 1 ? /* event passed */
                                                              ViaviStyle.colors.passColor : ViaviStyle.colors.getColor(model.alarmStatus)
                    }
                    
                    //subEventNumber
                    Text {
                    	visible: model.eventDedicatedDisplay
                    	
                    	text: "x" + model.subEventNumber
                    	
                    	anchors.top: parent.top
                        anchors.topMargin: ViaviStyle.layout.smallMargin
                        
                        anchors.left: parent.left
                        anchors.leftMargin: ViaviStyle.layout.smallMargin
                        
                        color: isSelectedEvent ? ViaviStyle.colors.activeItemTextColor : ViaviStyle.colors.activeColor
                        font: ViaviStyle.layout.smallBoldFont
                    }

                    // event number label
                    Text {
                        visible: isFirstEntryPlacholder ? false : true
                        anchors.bottom: parent.top
                        anchors.bottomMargin: ViaviStyle.layout.mediumMargin / 2

                        anchors.horizontalCenter: event.horizontalCenter

                        color: model.alarmStatus === alarmStatusFailed ? /* event failed */
                                                          ViaviStyle.colors.failedColor : isGroupEventSelected ? "white" : ViaviStyle.colors.mainInfoColor
                        font: ViaviStyle.layout.largeBoldFont
                        text: model.eventIndex + 1
                    }

                    // event distance label
                    Text {
                        visible: isFirstEntryPlacholder ? false : true

                        anchors.top: parent.bottom
                        anchors.topMargin: ViaviStyle.layout.mediumMargin / 2

                        anchors.horizontalCenter: event.horizontalCenter

                        color: isGroupEventSelected ? "white" : ViaviStyle.colors.secondaryInfoColor
                        font: ViaviStyle.layout.largeFont

                        text: schematic_cfg_slmDetailedMode.value === schematic_cfg_slmDetailedMode.enums.edmEvent
                              || schematic_cfg_slmDetailedMode.value === schematic_cfg_slmDetailedMode.enums.edmLink
                              ? model.eventLabel : model.eventDistance
                    }

                    // * for manually modified event codes
                    Text {
                        visible: model.isIconManual
                        anchors.bottom: parent.bottom
                        anchors.bottomMargin: -ViaviStyle.layout.largeBoldFontMetrics.height / 4
                        anchors.left: parent.left
                        anchors.leftMargin: ViaviStyle.layout.mediumMargin / 2

                        color: isSelectedEvent ? ViaviStyle.colors.activeItemTextColor : ViaviStyle.colors.activeColor
                        font: ViaviStyle.layout.largeBoldFont
                        text: "*"
                    }
                }

                Rectangle {
                    id: connection

                    width: slmUtils.getSchematicConnSize( model.connectionDistance,
                                                         model.totalConnectionsSum,
                                                         minConnLength )
                    height: isSelectedLink ? 6 * ViaviStyle.layout.borderSize : ViaviStyle.layout.borderSize
                    z: -1

                    anchors.verticalCenter: parent.verticalCenter
                    anchors.left: event.right

                    opacity: isSelectedLink ? 1 : schematic_cfg_slmDetailedMode.value === schematic_cfg_slmDetailedMode.enums.edmOff ? 1 : 0.5
                    color: ViaviStyle.colors.activeColor
                    visible: model.connectionDistance !== ""

                    // Group member double border
                    Rectangle {

                        visible: !isSelectedLink
                                  && (model.groupElementType === schematic_res_groupElementTypeEnum.enums.egetBegin
                                        || model.groupElementType === schematic_res_groupElementTypeEnum.enums.egetMiddle)

                        width: parent.width
                        height: parent.height * 6
                        z: parent.z

                        anchors.verticalCenter: parent.verticalCenter
                        anchors.left: parent.left

                        color: ViaviStyle.colors.disabledItemColor
                    }

                    // Connection distance label
                    Text {

                        anchors.bottom: parent.verticalCenter
                        anchors.bottomMargin: ViaviStyle.layout.largeMargin

                        anchors.horizontalCenter: parent.horizontalCenter

                        color: isGroupEventSelected ? "white" : ViaviStyle.colors.secondaryInfoColor
                        font: ViaviStyle.layout.largeFont

                        text: model.connectionDistance

                    }

                    Image {
                        id: linkStatusIcon

                        height: connection.height * 4
                        width: height
                        anchors.centerIn: parent

                        visible: isSelectedLink

                        fillMode: Image.PreserveAspectFit
                        source: FiberStyle.images.getAlarmIcon(events_res_alarm.value)
                    }
                }

                MouseArea{
                	id: evtMouseArea 
                    anchors.left: connection.left
                    anchors.right: connection.right
                    anchors.top: event.top
                    anchors.bottom: event.bottom

                    onClicked: {
                    	if(!schematic_res_isMotfDataVisible.value) {
                        	if(eventListView.count - 1 !== model.index) {
                        		schematic_cfg_slmCurrentGroupEvent.value = -1
                        	
                            	if ( isSelectedLink ) {
                                	if(!slmContainer.detailModeAlwaysOn) {
                                    	schematic_cfg_slmDetailedMode.value = schematic_cfg_slmDetailedMode.enums.edmOff;
                                	}
                            	}
                            	else {
                                	schematic_cfg_slmDetailedMode.value = schematic_cfg_slmDetailedMode.enums.edmLink;
                                	schematic_cfg_slmCurrentEvent.value = model.eventIndex + 1;
                            	}
                        	}
                    	}
                    }
                }

                Rectangle{
                    id: groupTopLine
                    visible: model.groupElementType !== schematic_res_groupElementTypeEnum.enums.egetNone

                    anchors.top: parent.top

                    height: ViaviStyle.layout.borderSize

                    // color: ViaviStyle.colors.borderColor
                    color: ViaviStyle.colors.getColor(model.groupAlarm)
                    
                    border.width: 0

                    anchors.left: parent.left
                    anchors.right: model.groupElementType !== schematic_res_groupElementTypeEnum.enums.egetEnd
                                    ? parent.right : groupRightLine.right
                }

                Rectangle{
                    id: groupBottomLine
                    visible: model.groupElementType !== schematic_res_groupElementTypeEnum.enums.egetNone

                    anchors.bottom: parent.bottom

                    height: ViaviStyle.layout.borderSize

                    // color: ViaviStyle.colors.borderColor
                    color: ViaviStyle.colors.getColor(model.groupAlarm)
                    
                    border.width: 0

                    anchors.left: parent.left
                    anchors.right: model.groupElementType !== schematic_res_groupElementTypeEnum.enums.egetEnd
                                    ? parent.right : groupRightLine.right
                }

                Rectangle{
                    id: groupLeftLine

                    visible: model.groupElementType === schematic_res_groupElementTypeEnum.enums.egetBegin

                    anchors.left: event.left
                    anchors.leftMargin: -ViaviStyle.layout.smallMargin

                    width: ViaviStyle.layout.borderSize

                    //color: ViaviStyle.colors.borderColor
                    color: ViaviStyle.colors.getColor(model.groupAlarm)
                    
                    border.width: 0

                    anchors.top: groupTopLine.top
                    anchors.bottom: groupBottomLine.bottom
                }

                Rectangle{
                    id: groupRightLine

                    visible: model.groupElementType === schematic_res_groupElementTypeEnum.enums.egetEnd

                    anchors.right: event.right
                    anchors.rightMargin: -ViaviStyle.layout.smallMargin

                    width: ViaviStyle.layout.borderSize

                    // color: ViaviStyle.colors.borderColor
                    color: ViaviStyle.colors.getColor(model.groupAlarm)
                    
                    border.width: 0

                    anchors.top: groupTopLine.top
                    anchors.bottom: groupBottomLine.bottom
                }
                
                ColorImage {
                    visible: model.groupElementType === schematic_res_groupElementTypeEnum.enums.egetEnd && model.groupAlarm !== 0 /* group is tested */
                    width: 20

                    anchors.top: groupTopLine.top
                    anchors.topMargin: ViaviStyle.layout.smallMargin

                    anchors.right: groupRightLine.left
                    anchors.rightMargin: ViaviStyle.layout.smallMargin

                    source: model.groupAlarm === alarmStatusFailed ? FiberStyle.images.iconFailedEvent : FiberStyle.images.iconPassedEvent
                    fillMode: Image.PreserveAspectFit
                    smooth: true

                    color: ViaviStyle.colors.getColor(model.groupAlarm)
                }
            }
        }
    }
    
    Text {
        visible: !(schematic_res_slmNotEmpty.value) && schematic_res_isTabResting.value
        
        anchors.horizontalCenter: parent.horizontalCenter
        anchors.verticalCenter: parent.verticalCenter

        color: ViaviStyle.colors.mainInfoColor
        font: ViaviStyle.layout.largeFont

        text: schematic_res_messageNoSlmDisplayed.value
    }

    // Unit label
    Text {
        id: unitText

        visible: schematic_res_slmNotEmpty.value
        anchors.bottom: parent.bottom
        anchors.bottomMargin: ViaviStyle.layout.mediumMargin / 2

        anchors.right: parent.right
        anchors.rightMargin: ViaviStyle.layout.largeMargin

        color: ViaviStyle.colors.mainInfoColor
        font: ViaviStyle.layout.largeBoldFont

        text: schematic_res_slmUnitLabel.value
    }
}

