import QtQuick 2.3
import libfo 1.0
import com.viavi.style 1.0

Rectangle {
    id: container

    height: 30
    width:  700
    
    property string textColor: ViaviStyle.colors.darkGray
    property bool textBold: true
    property int textSize: 16

    color: ViaviStyle.colors.lightGray2

    Row {
        anchors.fill: parent
        
        clip: true
        
        Repeater {
           id: repeaterContainer
           
           model: LineModel
           
           Rectangle {
              color: "transparent"
              
              height: parent.height
              width: RatioWidth * parent.width / 100
              
              clip: true
              
              Text {
                 visible: !IsIcon
                 text: ElementValue
                  
                 width: parent.width
                 height: parent.height
                  
                 color: textColor
                  
                 font.pixelSize: textSize
                 font.family: "Bitstream Vera Sans Roman"
                 font.bold: textBold
                  
                 horizontalAlignment: Text.AlignHCenter
                 verticalAlignment: Text.AlignVCenter
              }
              
              Image {
                 visible: IsIcon
                 
                 anchors.centerIn: parent
                 fillMode: Image.PreserveAspectFit
                 smooth:true
                 source: IsIcon ? ElementValue : ""
              }
           }
        }
    }
}
