import QtQuick 2.3

import com.viavi.style 1.0
import com.viavi.style.components 1.0
import com.viavi.fiberutilui 1.0

Rectangle {
    id: pow_win

    Column {
        id: powColumn
        anchors.top: parent.top
        anchors.topMargin: ViaviStyle.layout.mediumMargin
        anchors.left: parent.left
        anchors.leftMargin: ViaviStyle.layout.largeMargin
        anchors.right: parent.right
        anchors.rightMargin: ViaviStyle.layout.largeMargin

        height: parent.height * 0.6

        Pow_Pon_One {
            width: parent.width
            height: parent.height / 2
            pow_number : 1
        }

        Pow_Pon_One {
            width:  parent.width
            height: parent.height / 2
            pow_number : 2
        }
    }

    GenericTable {
        id: table
        anchors.top: powColumn.bottom
        anchors.topMargin: ViaviStyle.layout.mediumMargin
        anchors.left: parent.left
        anchors.leftMargin: ViaviStyle.layout.largeMargin
        anchors.right: parent.right
        anchors.rightMargin: ViaviStyle.layout.largeMargin
        anchors.bottom: parent.bottom
        anchors.bottomMargin: ViaviStyle.layout.mediumMargin

        titleAreaHeight: Math.max ( ViaviStyle.layout.imageButtonHeight + 2 * ViaviStyle.layout.smallMargin,
                                   2 * titleCellHeight )

        Row {
            anchors.top: parent.top
            anchors.topMargin: ViaviStyle.layout.smallMargin
            anchors.right: parent.right
            anchors.rightMargin: ViaviStyle.layout.largeMargin

            spacing: 2 * ViaviStyle.layout.largeMargin

            ColorImage {
                height: ViaviStyle.layout.imageButtonHeight
                width: height * 1.4

                fillMode: Image.PreserveAspectFit
                source: FiberStyle.images.keepResultsIconPath
                opacity: button.pressed ? 0.6 : 1

                MouseArea {
                    id: button
                    anchors.fill: parent
                    onClicked:{
                        numericdisplay_act_ponKeepResults.invoke()
                    }
                }
            }

            ImageButton {
                source: FiberStyle.images.deleteIcon
                onClicked:{
                    numericdisplay_act_ponClearResults.invoke()
                }
            }
        }
    }
}

