.pragma library

Qt.include("Viavi_Colors.js")

function pow_get_power( pow_digit ) 
{
	var value = "---,--";

	if (pow_digit.Status != 3) {
		value = pow_digit.Value;
	}
	
	if (pow_digit.Unit == "nW") {
		value = value.replace("+", "")
	}

	return (value + " <i style=\"color:" + cViaviColorLogoPurple + ";font-size:28px\">" + pow_digit.Unit + "</i>");
}

function pow_get_wavelength( pow_digit ) {
	var wave = "";
	
	wave = pow_digit.Wavelength;
	
	if (wave == "0")
		return "???";
	
	return (wave + " nm");
}

function pow_get_alarm_color( pow_digit ) {
	var value = cViaviColorRed;

	if ( pow_digit.AlarmOn ) {
		 value = (pow_digit.Alarm ) ? cViaviColorRed : cViaviColorGreen
	} else {
		value = cViaviColorMediumBlue
	}
	return (value)
}

function pow_get_icon( pow_digit ) {
	var path = ""

	if (pow_digit.Wavelength == "1490" ) {
		path = "/acterna/storage/look-and-feel/Mts1000/isu/Icon_Data_Flat.png"
	} else if (pow_digit.Wavelength == "1550" ) {
		path = "/acterna/storage/look-and-feel/Mts1000/isu/Icon_Tv_Flat.png"
	} else {
		path = "/acterna/storage/look-and-feel/Mts1000/isu/Icon_Data_Flat.png"
	}

	return (path)
}

function pow_get_name( pow_digit ) {
	var pow_name = ""

	if (pow_digit.Wavelength == "1490" ) {
		pow_name = "OLT"
	} else if (pow_digit.Wavelength == "1550" ) {
		pow_name = "RF Video"
	} else {
		pow_name = "XGPON"
	}

	return (pow_name)
}

function pow_get_pourcent( pow_digit ) {
	var pow_pourcent = 50
	
	pow_pourcent = pow_digit.Pourcent
	
	return (pow_pourcent)
}
