import QtQuick 2.3
import com.viavi.style 1.0
import com.viavi.style.components 1.0
import libpopup 1.0

BasicContainer {
    id: container

    readonly property int statusFailed: -1
    readonly property int statusPassed: 1

    property int numberOfButtons: 0

    MouseArea {
        id: warningMouseArea
        anchors.fill: parent
        onClicked: pop_up_manager.Close_PopUp_Box()
    }

    function get_status_icon( status )
    {
        var icon = "";

        if ( status === statusPassed )
        {
            icon = "/acterna/storage/fo/report/Wizard_Pass.png";
        }
        else if ( status === statusFailed )
        {
            icon = "/acterna/storage/fo/report/Wizard_Fail.png";
        }
        else
        {
            icon = "/acterna/storage/look-and-feel/generic/Pop_Up_Icon_Info.png"
        }

        return icon;
    }

    function get_status_txt_color( status )
    {
        var color = ViaviStyle.colors.mainInfoColor

        if ( status === statusPassed )
        {
            color = ViaviStyle.colors.passColor
        }
        else if ( status === statusFailed )
        {
            color = ViaviStyle.colors.failedColor
        }

        return color;
    }

    function get_status_border_color( status )
    {
        var color = ViaviStyle.colors.borderColor

        if ( status === statusPassed )
        {
            color = ViaviStyle.colors.passColor
        }
        else if ( status === statusFailed )
        {
            color = ViaviStyle.colors.failedColor
        }

        return color;
    }

    border.color: get_status_border_color(pop_up_manager.status)

    Image {
        id: infoIcon

        anchors.top: container.top
        anchors.topMargin: ViaviStyle.layout.largeMargin

        anchors.left: container.left
        anchors.leftMargin: ViaviStyle.layout.largeMargin

        source: get_status_icon( pop_up_manager.status )
    }

    Text {
        id: statusText

        anchors.left: infoIcon.right
        anchors.leftMargin: ViaviStyle.layout.mediumMargin
        anchors.verticalCenter: infoIcon.verticalCenter

        text: pop_up_manager.txtStatus

        font: ViaviStyle.layout.veryLargeBoldFont
        color: get_status_txt_color( pop_up_manager.status )
        horizontalAlignment: Text.AlignLeft
        wrapMode: Text.Wrap
    }

    Text {
        id: textStatusFail

        visible: pop_up_manager.status === statusFailed 

        anchors.left: statusText.right
        anchors.leftMargin: ViaviStyle.layout.largeMargin
        anchors.verticalCenter: infoIcon.verticalCenter
        anchors.right: container.right
        
        clip: true

        text: pop_up_manager.txtStatusFail

        font: ViaviStyle.layout.veryLargeFont
        color: ViaviStyle.colors.mainInfoColor
        horizontalAlignment: Text.AlignLeft
        wrapMode: Text.Wrap
    }

    Column {
        anchors.left: container.left
        anchors.leftMargin: ViaviStyle.layout.largeMargin
        anchors.right: container.right
        anchors.rightMargin: ViaviStyle.layout.largeMargin
        anchors.top: infoIcon.bottom
        anchors.topMargin: ViaviStyle.layout.largeMargin

        Text {
            id: mainText

            anchors.left: parent.left
            anchors.right: parent.right

            text: pop_up_manager.txtDisplay

            font: ViaviStyle.layout.largeFont
            color: ViaviStyle.colors.mainInfoColor
            horizontalAlignment: Text.AlignLeft
            wrapMode: Text.Wrap
        }


        Text {
            id: subText

            anchors.left: parent.left
            anchors.right: parent.right

            text: pop_up_manager.subTxtDisplay

            font: ViaviStyle.layout.largeFont
            color: ViaviStyle.colors.mainInfoColor
            horizontalAlignment: Text.AlignLeft
            wrapMode: Text.Wrap
        }
    }

    Text {
        id: exitText

        visible: numberOfButtons == 0

        anchors.bottom: parent.bottom
        anchors.bottomMargin: ViaviStyle.layout.smallMargin
        anchors.left: parent.left
        anchors.leftMargin: ViaviStyle.layout.mediumMargin

        text: pop_up_manager.txtExit

        font: ViaviStyle.layout.mediumFont
        color: ViaviStyle.colors.mainInfoColor
    }
}
