import QtQuick 2.3
import QtQuick.Layouts 1.2
import QtQuick.Controls 2.0

import com.viavi.style 1.0
import com.viavi.style.components 1.0
import com.viavi.fiberutilui.components 1.0
import com.viavi.fiberutilui 1.0

Popup
{
    id: root

    width: parent.width
    height: parent.height

    background: Rectangle{

        anchors.fill: parent

        color: ViaviStyle.colors.transparentBackgroundColor

        MouseArea{
            anchors.fill: parent

            onClicked: {

            }
        }
    }

    BasicContainer{
        anchors.fill: parent
        anchors.margins: ViaviStyle.layout.veryLargeMargin

        ColumnLayout{
            id: mainArea
            anchors.fill: parent
            anchors.margins: ViaviStyle.layout.mediumMargin

            Item {

                Layout.fillWidth: true

                height: ViaviStyle.layout.buttonHeight


                ImageButton{
                    id: button

                    anchors.right: parent.right

                    source: FiberStyle.images.closeButtonIcon

                    onClicked:{
                        pibGrid_act_closeGrid.invoke()
                    }
                }
            }

            Item {
               Layout.fillWidth: true

                height: ViaviStyle.layout.buttonHeight

                ImageButton{

                    anchors.left: parent.left

                    source: FiberStyle.images.addIcon

                    onClicked:{
                        pibGrid_act_addSelected.invoke()
                    }
                }

                Button {
                    width: ViaviStyle.layout.buttonHeight * 5
                    height: ViaviStyle.layout.buttonHeight

                    anchors.right: deselectAll.left
                    anchors.rightMargin: ViaviStyle.layout.mediumMargin

                    text: pibGrid_res_selectAllButtonText.value

                    onClicked:{
                        pibGrid_act_selectAll.invoke()
                    }
                }

                Button {
                    id: deselectAll

                    width: ViaviStyle.layout.buttonHeight * 5
                    height: ViaviStyle.layout.buttonHeight

                    anchors.right: parent.right

                    text: pibGrid_res_deselectAllButtonText.value

                    onClicked:{
                       pibGrid_act_deselectAll.invoke()
                    }
                }
            }

            property int nrOfColumns: 4
            property real cellWidth: width / nrOfColumns

            TableHeaderRow{
                TableHeaderCell{
                    width: mainArea.cellWidth
                    valueTextHorizontalAllignment: Text.AlignHCenter
                    valueTextVerticalAlignment: Text.AlignVCenter
                    valueText: pibGrid_res_channelNumberHeader.value
                }
                TableHeaderCell{
                    width:  mainArea.cellWidth
                    valueTextHorizontalAllignment: Text.AlignHCenter
                    valueTextVerticalAlignment: Text.AlignVCenter
                    valueText: pibGrid_res_osaFRefHeader.value
                }
                TableHeaderCell{
                    width:  mainArea.cellWidth
                    valueTextHorizontalAllignment: Text.AlignHCenter
                    valueTextVerticalAlignment: Text.AlignVCenter
                    valueText: pibGrid_res_osaLRefHeader.value
                }
                TableHeaderCell{
                    id: selectedHeaderCell
                    width:  mainArea.cellWidth
                    valueTextHorizontalAllignment: Text.AlignHCenter
                    valueTextVerticalAlignment: Text.AlignVCenter
                    valueText: pibGrid_res_selectedHeader.value


                    canFilter: true

                    onFilterChanged: pibGrid_cfg_filterSelected.value = filter

                    Component.onCompleted: {
                        filter = pibGrid_cfg_filterSelected.value
                    }
                }
            }

            ListView {
                id: list
                Layout.fillWidth: true
                Layout.fillHeight: true

                boundsBehavior: Flickable.OvershootBounds
                clip: true
                model: pibGrid_res_gridTable.value



                delegate: TableRow {
                    TableTextCell{
                        id: indexCell
                        width: mainArea.cellWidth
                        valueTextHorizontalAllignment: Text.AlignHCenter
                        valueTextVerticalAlignment: Text.AlignVCenter
                        valueText: channelNumber
                    }

                    TableTextCell{
                        width: mainArea.cellWidth
                        valueTextHorizontalAllignment: Text.AlignHCenter
                        valueTextVerticalAlignment: Text.AlignVCenter
                        valueText: osaFRef
                    }

                    TableTextCell{
                        width: mainArea.cellWidth
                        valueTextHorizontalAllignment: Text.AlignHCenter
                        valueTextVerticalAlignment: Text.AlignVCenter
                        valueText: osaLRef
                    }

                    TableTextCell{
                        width: mainArea.cellWidth
                        valueTextHorizontalAllignment: Text.AlignHCenter
                        valueTextVerticalAlignment: Text.AlignVCenter
                        valueText: selected
                    }

                    onClicked: {
                        pibGrid_act_toggleChannel.invokeWithStringArg(channelIndex)
                    }
                }
            }
        }
    }
}
