﻿import QtQuick 2.3
import QtQuick.Controls 2.0
import elf_plugin 1.0

import QtQuick.Layouts 1.2

import com.viavi.style 1.0
import com.viavi.fiberutilui.components 1.0

Row {
    id: rootId

    spacing: ViaviStyle.layout.isSmallScreen ?
                 ViaviStyle.layout.veryLargeMargin * 2 : ViaviStyle.layout.veryLargeMargin

    CheckTextButton{
        height: parent.height

        visible: multigraphsStates_res_isPmdSpectreAvailable.value
        checked: multigraphsStates_res_isPmdSpectreActive.value

        text: multigraphsStates_res_spectreLabel.value

        mouseArea.onClicked: multigraphsStates_act_switchToPmdSpectre.invoke()
    }

    CheckTextButton {
        id: traceTabButton
        height: parent.height

        visible: multigraphsStates_res_isPmdFftAvailable.value
        checked: multigraphsStates_res_isPmdFftActive.value

        text: multigraphsStates_res_fftLabel.value

        mouseArea.onClicked: multigraphsStates_act_switchToPmdFft.invoke()
    }

    CheckTextButton{
        height: parent.height

        visible: multigraphsStates_res_isPmdDriftAvailable.value

        checked: multigraphsStates_res_isPmdDriftActive.value

        text: multigraphsStates_res_driftLabel.value

        mouseArea.onClicked: multigraphsStates_act_switchToPmdDrift.invoke()
    }

    CheckTextButton{
        height: parent.height

        visible: multigraphsStates_res_isPmdHistoAvailable.value

        checked: multigraphsStates_res_isPmdHistoActive.value

        text: multigraphsStates_res_histoLabel.value

        mouseArea.onClicked: multigraphsStates_act_switchToPmdHisto.invoke()
    }

    CheckTextButton{
        height: parent.height

        visible: multigraphsStates_res_isPmdExtremesAvailable.value

        checked: multigraphsStates_res_isPmdExtremesActive.value

        text: multigraphsStates_res_extremesLabel.value

        mouseArea.onClicked: multigraphsStates_act_switchToPmdExtremes.invoke()
    }
}
